/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.twowaysql.node;

import java.lang.reflect.Array;
import java.util.List;
import org.seasar.dbflute.twowaysql.context.CommandContext;
import org.seasar.dbflute.twowaysql.node.AbstractNode;
import org.seasar.dbflute.util.DfOgnlUtil;

public class ParenBindVariableNode
extends AbstractNode {
    private String expression;
    private Object parsedExpression;

    public ParenBindVariableNode(String expression) {
        this.expression = expression;
        this.parsedExpression = DfOgnlUtil.parseExpression(expression);
    }

    public String getExpression() {
        return this.expression;
    }

    public void accept(CommandContext ctx) {
        Object var = DfOgnlUtil.getValue(this.parsedExpression, ctx);
        if (var instanceof List) {
            this.bindArray(ctx, ((List)var).toArray());
        } else {
            if (var == null) {
                return;
            }
            if (var.getClass().isArray()) {
                this.bindArray(ctx, var);
            } else {
                ctx.addSql("?", var, var.getClass());
            }
        }
    }

    private void bindArray(CommandContext ctx, Object array) {
        int i;
        int length = Array.getLength(array);
        if (length == 0) {
            return;
        }
        Class<?> clazz = null;
        for (i = 0; i < length; ++i) {
            Object o = Array.get(array, i);
            if (o == null) continue;
            clazz = o.getClass();
        }
        ctx.addSql("(");
        ctx.addSql("?", Array.get(array, 0), clazz);
        for (i = 1; i < length; ++i) {
            ctx.addSql(", ?", Array.get(array, i), clazz);
        }
        ctx.addSql(")");
    }
}

