/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.util;

import java.util.ArrayList;
import java.util.StringTokenizer;

public class DfStringUtil {
    protected static final String[] EMPTY_STRINGS = new String[0];

    public static final boolean isEmpty(String text) {
        return text == null || text.length() == 0;
    }

    public static final boolean isNotEmpty(String text) {
        return !DfStringUtil.isEmpty(text);
    }

    public static String replace(String text, String fromText, String toText) {
        if (text == null || fromText == null || toText == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        int pos2 = 0;
        while (true) {
            if ((pos = text.indexOf(fromText, pos2)) == 0) {
                sb.append(toText);
                pos2 = fromText.length();
                continue;
            }
            if (pos <= 0) break;
            sb.append(text.substring(pos2, pos));
            sb.append(toText);
            pos2 = pos + fromText.length();
        }
        sb.append(text.substring(pos2));
        return sb.toString();
    }

    public static String[] split(String str, String delimiter) {
        if (str == null || str.trim().length() == 0) {
            return EMPTY_STRINGS;
        }
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(str, delimiter);
        while (st.hasMoreElements()) {
            list.add(st.nextToken());
        }
        return list.toArray(new String[list.size()]);
    }

    public static String initCap(String str) {
        DfStringUtil.assertObjectNotNull("str", str);
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    public static String initUncap(String str) {
        DfStringUtil.assertObjectNotNull("str", str);
        return str.substring(0, 1).toLowerCase() + str.substring(1);
    }

    public static String fromPropertyNameToColumnName(String propertyName) {
        return DfStringUtil.decamelize(propertyName);
    }

    public static String fromEntityNameToTableName(String entityName) {
        return DfStringUtil.decamelize(entityName);
    }

    protected static String decamelize(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() == 1) {
            return s.toUpperCase();
        }
        StringBuffer buf = new StringBuffer(40);
        int pos = 0;
        for (int i = 1; i < s.length(); ++i) {
            if (!Character.isUpperCase(s.charAt(i))) continue;
            if (buf.length() != 0) {
                buf.append('_');
            }
            buf.append(s.substring(pos, i).toUpperCase());
            pos = i;
        }
        if (buf.length() != 0) {
            buf.append('_');
        }
        buf.append(s.substring(pos, s.length()).toUpperCase());
        return buf.toString();
    }

    protected static void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=" + variableName + " value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }
}

