/*
 * Decompiled with CFR 0.152.
 */
package webshell.app;

import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.security.Keys;
import java.security.Provider;
import java.security.Security;
import javax.crypto.SecretKey;
import javax.servlet.Filter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.config.annotation.EnableWebSocket;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;
import webshell.app.Application;
import webshell.app.config.ConfigManager;
import webshell.app.security.CustomAuthEntryPoint;
import webshell.app.security.JwtAuthorizationFilter;
import webshell.app.terminal.TerminalWebsocketHandler;

@EnableWebSecurity
@EnableWebSocket
@SpringBootApplication
public class Application
extends WebSecurityConfigurerAdapter
implements WebSocketConfigurer,
WebMvcConfigurer,
CommandLineRunner {
    @Autowired
    private Environment env;
    public static final SecretKey SECRET_KEY;
    @Autowired
    private CustomAuthEntryPoint auth;

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        ConfigManager.checkAndConfigureSSL();
        SECRET_KEY = Keys.secretKeyFor((SignatureAlgorithm)SignatureAlgorithm.HS256);
    }

    public static void main(String[] args) throws Exception {
        SpringApplication.run(Application.class, (String[])args);
    }

    public void registerWebSocketHandlers(WebSocketHandlerRegistry registry) {
        System.out.println("Encoded: " + this.passwordEncoder().encode((CharSequence)"admin"));
        System.out.println("Registered ws");
        registry.addHandler((WebSocketHandler)new TerminalWebsocketHandler(), new String[]{"/term*"}).setAllowedOrigins(new String[]{"*"});
    }

    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping("/**");
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.httpBasic().authenticationEntryPoint((AuthenticationEntryPoint)this.auth).and()).cors().and()).csrf().disable()).authorizeRequests().antMatchers(new String[]{"/term**"})).permitAll().and()).authorizeRequests().antMatchers(new String[]{"/bin/**"})).permitAll().and()).authorizeRequests().antMatchers(new String[]{"/api/**"})).authenticated().and()).authorizeRequests().antMatchers(new String[]{"/**"})).permitAll().and()).addFilter((Filter)new JwtAuthorizationFilter(this.authenticationManager())).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS);
    }

    @Bean
    public BCryptPasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

    public void configure(AuthenticationManagerBuilder auth) throws Exception {
        1 provider = new /* Unavailable Anonymous Inner Class!! */;
        auth.authenticationProvider((AuthenticationProvider)provider);
    }

    public void run(String ... args) throws Exception {
        ConfigManager.loadUserDetails((Environment)this.env);
    }
}

