/*
 * Decompiled with CFR 0.152.
 */
package webshell.app.files;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class FileTransfer {
    private final byte[] BUFFER = new byte[8192];
    private boolean compress;

    public FileTransfer(boolean compress) {
        this.compress = compress;
    }

    public void transferFile(String relativePath, String folder, InputStream in) {
        File f = new File(folder, relativePath);
        File parent = f.getParentFile();
        parent.mkdirs();
        System.out.println("Creating folder: " + parent.getAbsolutePath());
        System.out.println("Creating file: " + f.getAbsolutePath());
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (FileOutputStream out = new FileOutputStream(f);){
                this.copyStream(in, (OutputStream)out);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void transferFiles(List<String> files, OutputStream out) {
        if (!this.compress) {
            try {
                Throwable throwable = null;
                Object var4_9 = null;
                try (FileInputStream in = new FileInputStream(files.get(0));){
                    this.copyStream((InputStream)in, out);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                Throwable e = null;
                Object var4_11 = null;
                try (ZipOutputStream zout = new ZipOutputStream(out);){
                    for (String file : files) {
                        File f = new File(file);
                        if (f.isDirectory()) {
                            if (this.walkTree(f, zout, f.getName())) continue;
                            return;
                        }
                        boolean writing = false;
                        try {
                            Throwable throwable = null;
                            Object var11_22 = null;
                            try (FileInputStream in = new FileInputStream(f);){
                                ZipEntry ze = new ZipEntry(f.getName());
                                ze.setSize(f.length());
                                writing = true;
                                zout.putNextEntry(ze);
                                this.copyStream((InputStream)in, (OutputStream)zout);
                                zout.closeEntry();
                                writing = false;
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                throw throwable;
                            }
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                        if (!writing) continue;
                        return;
                    }
                }
                catch (Throwable throwable) {
                    if (e == null) {
                        e = throwable;
                    } else if (e != throwable) {
                        e.addSuppressed(throwable);
                    }
                    throw e;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean walkTree(File folder, ZipOutputStream zout, String relativePath) {
        System.out.println("Walking: " + folder.getAbsolutePath() + " - " + relativePath);
        try {
            File[] files = folder.listFiles();
            if (files == null) return true;
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return true;
                }
                File f = fileArray[n2];
                if (f.isDirectory()) {
                    if (!this.walkTree(f, zout, this.combine(relativePath, f.getName(), File.separator))) {
                        return false;
                    }
                } else {
                    boolean writing = false;
                    try {
                        Throwable throwable = null;
                        Object var11_14 = null;
                        try (FileInputStream in = new FileInputStream(f);){
                            ZipEntry ze = new ZipEntry(this.combine(relativePath, f.getName(), File.separator));
                            ze.setSize(f.length());
                            writing = true;
                            zout.putNextEntry(ze);
                            this.copyStream((InputStream)in, (OutputStream)zout);
                            zout.closeEntry();
                            writing = false;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                                throw throwable;
                            }
                            if (throwable == throwable2) throw throwable;
                            throwable.addSuppressed(throwable2);
                            throw throwable;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (writing) {
                        throw new Exception("error reading file: " + f.getAbsolutePath());
                    }
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void copyStream(InputStream in, OutputStream out) throws IOException {
        int x;
        while ((x = in.read(this.BUFFER)) != -1) {
            out.write(this.BUFFER, 0, x);
        }
    }

    public String combine(String path1, String path2, String separator) {
        if (path2.startsWith(separator)) {
            path2 = path2.substring(1);
        }
        if (!path1.endsWith(separator)) {
            return String.valueOf(path1) + separator + path2;
        }
        return String.valueOf(path1) + path2;
    }
}

