/*
 * Decompiled with CFR 0.152.
 */
package webshell.app.files.copy;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;

public class FileCopyTask
implements Runnable {
    private long total;
    private long copied;
    private List<String> src;
    private String target;
    private boolean move;
    private String status;
    private final byte[] BUFFER = new byte[8192];
    private List<String> errorMessage = new ArrayList();
    private boolean hasErrors = false;
    private AtomicBoolean stopRequested = new AtomicBoolean(false);
    private String id = UUID.randomUUID().toString();

    public FileCopyTask(List<String> src, String target, boolean move) {
        this.src = src;
        this.target = target;
        this.move = move;
        this.status = "Waiting...";
    }

    @Override
    public void run() {
        File f;
        for (String s : this.src) {
            f = new File(s);
            this.calculateSize(f, this.target);
            if (!this.stopRequested.get()) continue;
            return;
        }
        for (String s : this.src) {
            f = new File(s);
            this.moveFiles(f, this.target);
            if (!this.stopRequested.get()) continue;
            return;
        }
        this.status = "Finished";
    }

    public double getProgress() {
        if (this.total < 1L) {
            return 0.0;
        }
        return (double)this.copied * 100.0 / (double)this.total;
    }

    private void calculateSize(File f, String targetFolder) {
        this.status = "Preparing...";
        if (this.stopRequested.get()) {
            return;
        }
        String name = f.getName();
        File targetFile = new File(targetFolder, name);
        if (f.isDirectory()) {
            File[] files = null;
            try {
                files = f.listFiles();
                if (this.stopRequested.get()) {
                    return;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (files == null || files.length < 1) {
                return;
            }
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                this.calculateSize(file, targetFile.getAbsolutePath());
                ++n2;
            }
        } else {
            this.total += f.length();
        }
    }

    private void moveFiles(File f, String targetFolder) {
        String string = this.status = this.move ? "Moving files ..." : "Copying files ...";
        if (this.stopRequested.get()) {
            return;
        }
        String name = f.getName();
        File targetFile = new File(targetFolder, name);
        if (f.isDirectory()) {
            targetFile.mkdirs();
            File[] files = null;
            try {
                files = f.listFiles();
                if (this.stopRequested.get()) {
                    return;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (files == null || files.length < 1) {
                return;
            }
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                this.moveFiles(file, targetFile.getAbsolutePath());
                if (this.stopRequested.get()) {
                    return;
                }
                ++n2;
            }
        } else {
            this.copy(f, targetFile);
        }
        if (this.move && !f.delete()) {
            this.hasErrors = true;
            this.errorMessage.add("Error deleting:  " + this.src + ";");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void copy(File src, File target) {
        if (this.stopRequested.get()) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                FileInputStream in = new FileInputStream(src);
                try {
                    try (FileOutputStream out = new FileOutputStream(target);){
                        while (!this.stopRequested.get()) {
                            int x = ((InputStream)in).read(this.BUFFER);
                            if (x == -1) {
                                break;
                            }
                            ((OutputStream)out).write(this.BUFFER, 0, x);
                            this.copied += (long)x;
                            Thread.sleep(10L);
                        }
                    }
                    if (in == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (in == null) throw throwable;
                    ((InputStream)in).close();
                    throw throwable;
                }
                ((InputStream)in).close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.hasErrors = true;
            e.printStackTrace();
            this.errorMessage.add("Error copying:  " + src + " to " + target + " - " + e.getMessage());
            return;
        }
    }

    public long getTotal() {
        return this.total;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public long getCopied() {
        return this.copied;
    }

    public void setCopied(long copied) {
        this.copied = copied;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public List<String> getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(List<String> errorMessage) {
        this.errorMessage = errorMessage;
    }

    public boolean isHasErrors() {
        return this.hasErrors;
    }

    public void setHasErrors(boolean hasErrors) {
        this.hasErrors = hasErrors;
    }

    public AtomicBoolean getStopRequested() {
        return this.stopRequested;
    }

    public void setStopRequested(AtomicBoolean stopRequested) {
        this.stopRequested = stopRequested;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.src.size() == 1 ? (String)this.src.get(0) : String.valueOf((String)this.src.get(0)) + (this.src.size() - 1) + " files";
    }

    public void cancel() {
        this.stopRequested.set(true);
    }
}

