/*
 * Decompiled with CFR 0.152.
 */
package webshell.app.files.search;

import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import webshell.app.files.FileInfo;

public class SearchTask
implements Runnable {
    private boolean posix;
    private String id;
    private AtomicBoolean isDone = new AtomicBoolean(false);
    private List<FileInfo> files = Collections.synchronizedList(new ArrayList());
    private String folder;
    private String searchText;
    private AtomicBoolean stopRequested = new AtomicBoolean(false);

    public SearchTask(String folder, String searchText) {
        this.id = UUID.randomUUID().toString();
        this.folder = this.folder == null || this.folder.length() < 1 ? System.getProperty("user.home") : folder;
        this.searchText = searchText.toLowerCase(Locale.ENGLISH);
        this.posix = !System.getProperty("os.name").toLowerCase().contains("windows");
    }

    public boolean isDone() {
        return this.isDone.get();
    }

    public void setDone(boolean isDone) {
        this.isDone.set(isDone);
    }

    public List<FileInfo> getFiles() {
        return this.files;
    }

    public void setFiles(List<FileInfo> files) {
        this.files = files;
    }

    public AtomicBoolean getStopRequested() {
        return this.stopRequested;
    }

    public void stop() {
        System.out.println("Stopping...");
        this.stopRequested.set(true);
    }

    @Override
    public void run() {
        try {
            System.out.println("Search start");
            Files.walkFileTree(Paths.get(this.folder, new String[0]), (FileVisitor<? super Path>)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Search finished");
        this.isDone.set(true);
    }

    public String getSearchText() {
        return this.searchText;
    }

    public void setSearchText(String searchText) {
        this.searchText = searchText.toLowerCase(Locale.ENGLISH);
    }

    public String getFolder() {
        return this.folder;
    }

    public void setFolder(String folder) {
        this.folder = folder;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    static /* synthetic */ AtomicBoolean access$0(SearchTask searchTask) {
        return searchTask.stopRequested;
    }

    static /* synthetic */ String access$1(SearchTask searchTask) {
        return searchTask.searchText;
    }

    static /* synthetic */ boolean access$2(SearchTask searchTask) {
        return searchTask.posix;
    }

    static /* synthetic */ List access$3(SearchTask searchTask) {
        return searchTask.files;
    }
}

