/*
 * Decompiled with CFR 0.152.
 */
package webshell.app.terminal;

import com.pty4j.PtyProcess;
import com.pty4j.PtyProcessBuilder;
import com.pty4j.WinSize;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.UUID;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import webshell.app.terminal.SshPtyProcess;

public class PtySession
implements Runnable {
    private String id;
    private WebSocketSession ws;
    private Thread t;
    private PtyProcess pty;
    private OutputStream out;
    private InputStream os;
    private boolean ptyAllowed;
    private SshPtyProcess proc;

    public PtySession() throws Exception {
        block6: {
            String[] stringArray;
            this.id = UUID.randomUUID().toString();
            this.ptyAllowed = true;
            if ("auto".equals(System.getProperty("app.default-shell"))) {
                if (System.getProperty("os.name").toLowerCase().contains("windows")) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = "cmd";
                } else {
                    String[] stringArray3 = new String[2];
                    stringArray3[0] = "/bin/bash";
                    stringArray = stringArray3;
                    stringArray3[1] = "-l";
                }
            } else {
                String[] stringArray4 = new String[1];
                stringArray = stringArray4;
                stringArray4[0] = System.getProperty("app.default-shell");
            }
            String[] cmd = stringArray;
            try {
                HashMap<String, String> env = new HashMap<String, String>();
                env.put("TERM", "xterm");
                PtyProcessBuilder pb = new PtyProcessBuilder(cmd);
                pb.setRedirectErrorStream(true);
                pb.setEnvironment(env);
                this.pty = pb.start();
                this.os = this.pty.getInputStream();
                this.out = this.pty.getOutputStream();
                System.out.println("Pty created");
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!"true".equals(System.getProperty("app.fallback-local-ssh"))) break block6;
                this.proc = new SshPtyProcess(System.getProperty("app.local-ssh-host"), System.getProperty("app.local-ssh-user"), Integer.parseInt(System.getProperty("app.local-ssh-port")), System.getProperty("app.local-ssh-password"), System.getProperty("app.local-ssh-keyfile"), System.getProperty("app.local-ssh-passphrase"));
                this.proc.connect();
                this.os = this.proc.getIn();
                this.out = this.proc.getOut();
            }
        }
    }

    public void start() {
        this.t = new Thread((Runnable)this);
        this.t.start();
    }

    @Override
    public void run() {
        block19: {
            try {
                try {
                    byte[] buf = new byte[512];
                    try {
                        while (true) {
                            int x;
                            if ((x = this.os.read(buf)) == -1) {
                                System.out.println("Stream end");
                                break;
                            }
                            this.ws.sendMessage((WebSocketMessage)new TextMessage((CharSequence)new String(buf, 0, x, "utf-8")));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (this.ptyAllowed && this.pty != null) {
                        System.out.println("Waiting for pty...");
                        this.pty.waitFor();
                    } else if (this.proc != null) {
                        System.out.println("Waiting fot proc...");
                        this.proc.waitFor();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (this.pty != null) {
                        this.pty.destroy();
                    }
                    if (this.proc != null) {
                        this.proc.close();
                    }
                    break block19;
                }
            }
            catch (Throwable throwable) {
                if (this.pty != null) {
                    this.pty.destroy();
                }
                if (this.proc != null) {
                    this.proc.close();
                }
                throw throwable;
            }
            if (this.pty != null) {
                this.pty.destroy();
            }
            if (this.proc != null) {
                this.proc.close();
            }
        }
        System.out.println("Thread finished");
    }

    public void sendData(String text) {
        try {
            this.out.write(text.getBytes("utf-8"));
            this.out.flush();
            System.out.println("sent text");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void close() {
        if (this.pty != null) {
            this.pty.destroyForcibly();
        }
        if (this.proc != null) {
            this.proc.close();
        }
    }

    public void resizePty(int row, int col) {
        if (this.pty != null) {
            this.pty.setWinSize(new WinSize(col, row));
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public WebSocketSession getWs() {
        return this.ws;
    }

    public void setWs(WebSocketSession ws) {
        this.ws = ws;
    }

    public Thread getT() {
        return this.t;
    }

    public void setT(Thread t) {
        this.t = t;
    }

    public PtyProcess getPty() {
        return this.pty;
    }

    public void setPty(PtyProcess pty) {
        this.pty = pty;
    }
}

