/*
 * Decompiled with CFR 0.152.
 */
package webshell.app.terminal;

import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.InputStream;
import java.io.OutputStream;
import webshell.app.terminal.SshPtyProcess;

public class SshPtyProcess {
    private JSch jsch;
    private Session session;
    private String host;
    private String user;
    private int port;
    private String keyFile;
    private String passphrase;
    private String password;
    private OutputStream out;
    private ChannelShell shell;
    private InputStream in;

    public SshPtyProcess(String host, String user, int port, String password, String keyFile, String passphrase) {
        this.host = host;
        this.user = user;
        this.port = port;
        this.password = password;
        this.keyFile = keyFile;
        this.passphrase = passphrase;
    }

    public void connect() throws Exception {
        MyUserInfo info = new MyUserInfo(this);
        this.jsch = new JSch();
        JSch.setConfig((String)"MaxAuthTries", (String)"5");
        if (this.keyFile != null && this.keyFile.length() > 0) {
            this.jsch.addIdentity(this.keyFile);
        }
        this.session = this.jsch.getSession(this.user, this.host, this.port);
        this.session.setUserInfo((UserInfo)info);
        this.session.setPassword(info.getPassword());
        this.session.setConfig("PreferredAuthentications", "publickey,keyboard-interactive,password");
        this.session.connect();
        System.out.println("Client version: " + this.session.getClientVersion());
        System.out.println("Server host: " + this.session.getHost());
        System.out.println("Server version: " + this.session.getServerVersion());
        System.out.println("Hostkey: " + this.session.getHostKey().getFingerPrint(this.jsch));
        this.shell = (ChannelShell)this.session.openChannel("shell");
        this.in = this.shell.getInputStream();
        this.out = this.shell.getOutputStream();
        this.shell.connect();
    }

    public JSch getJsch() {
        return this.jsch;
    }

    public void setJsch(JSch jsch) {
        this.jsch = jsch;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getKeyFile() {
        return this.keyFile;
    }

    public void setKeyFile(String keyFile) {
        this.keyFile = keyFile;
    }

    public String getPassphrase() {
        return this.passphrase;
    }

    public void setPassphrase(String passphrase) {
        this.passphrase = passphrase;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public OutputStream getOut() {
        return this.out;
    }

    public void setOut(OutputStream out) {
        this.out = out;
    }

    public ChannelShell getShell() {
        return this.shell;
    }

    public void setShell(ChannelShell shell) {
        this.shell = shell;
    }

    public InputStream getIn() {
        return this.in;
    }

    public void setIn(InputStream in) {
        this.in = in;
    }

    public void close() {
        try {
            this.shell.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.session.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("Ssh shell closed");
    }

    public void waitFor() {
        while (this.shell.isConnected()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    static /* synthetic */ String access$0(SshPtyProcess sshPtyProcess) {
        return sshPtyProcess.passphrase;
    }

    static /* synthetic */ String access$1(SshPtyProcess sshPtyProcess) {
        return sshPtyProcess.password;
    }

    static /* synthetic */ OutputStream access$2(SshPtyProcess sshPtyProcess) {
        return sshPtyProcess.out;
    }
}

