/*
 * Decompiled with CFR 0.152.
 */
package webshell.app.terminal;

import io.jsonwebtoken.Jwts;
import java.net.URI;
import java.security.Key;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.AbstractWebSocketHandler;
import org.springframework.web.util.UriComponentsBuilder;
import webshell.app.AppContext;
import webshell.app.Application;
import webshell.app.terminal.PtySession;

public class TerminalWebsocketHandler
extends AbstractWebSocketHandler {
    private static final Logger logger = LoggerFactory.getLogger(TerminalWebsocketHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterConnectionEstablished(WebSocketSession session) throws Exception {
        logger.info("Incoming session: " + session.getId() + " url: " + session.getUri());
        TerminalWebsocketHandler terminalWebsocketHandler = this;
        synchronized (terminalWebsocketHandler) {
            URI uri = session.getUri();
            MultiValueMap params = UriComponentsBuilder.fromUri((URI)uri).build().getQueryParams();
            try {
                String token = (String)params.getFirst((Object)"token");
                Jwts.parser().setSigningKey((Key)Application.SECRET_KEY).parseClaimsJws(token);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                session.close(CloseStatus.BAD_DATA);
                return;
            }
            String appId = (String)params.getFirst((Object)"id");
            PtySession app = (PtySession)AppContext.INSTANCES.get(appId);
            if (app == null) {
                logger.error("No instance for session id: " + session.getId() + " data: " + uri);
                session.close(CloseStatus.BAD_DATA);
                return;
            }
            app.setWs(session);
            AppContext.SESSION_MAP.put(session.getId(), app);
            app.start();
        }
        logger.info("Handshake complete session: " + session.getId() + " url: " + session.getUri());
    }

    protected void handleTextMessage(WebSocketSession session, TextMessage message) throws Exception {
        System.out.println("Message received: " + (String)message.getPayload());
        PtySession app = (PtySession)AppContext.SESSION_MAP.get(session.getId());
        if (app == null) {
            logger.error("Invalid app id: " + session.getId());
            session.close(CloseStatus.BAD_DATA);
            return;
        }
        app.sendData((String)message.getPayload());
    }

    public void afterConnectionClosed(WebSocketSession session, CloseStatus status) throws Exception {
        System.out.println("Session closed: " + session.getId());
        PtySession app = (PtySession)AppContext.SESSION_MAP.get(session.getId());
        if (app != null) {
            app.close();
            AppContext.SESSION_MAP.remove(session.getId());
            logger.info("Session closed");
        }
    }
}

