/*
 * Decompiled with CFR 0.152.
 */
package easyhttpd.http;

import easyhttpd.EasyHttpd;
import easyhttpd.http.HttpProtocolException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;

public class HttpRequest {
    private static final String HEADER_CONNECTION = "Connection";
    private static final String HEADER_CONTENT_LENGTH = "Content-Length";
    private static final String HEADER_CONTENT_TYPE = "Content-Type";
    private static final String HEADER_HOST = "Host";
    private static final String HEADER_USER_AGENT = "User-Agent";
    private static final String HEADER_IF_MODIFIED_SINCE = "If-Modified-Since";
    private String method;
    private URL url;
    private int majorVersion;
    private int minorVersion;
    private HashMap header = new HashMap();
    private byte[] data;

    private void initFields() {
        this.method = null;
        this.url = null;
        this.majorVersion = 0;
        this.minorVersion = 0;
        this.header.clear();
        this.data = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseRequestLine(String line) throws HttpProtocolException {
        EasyHttpd.getLogger().finest(line);
        if (line == null || line.length() <= 0 || !line.matches("(?i:GET|POST|HEAD) (http://[^/]+){0,1}/.* HTTP/[0-9].[0-9]")) throw new HttpProtocolException(400, "Bad Request");
        String[] parts = line.split(" ");
        parts[0] = parts[0].toUpperCase();
        if (!parts[0].equals("GET") && !parts[0].equals("POST")) {
            throw new HttpProtocolException(405, "Method Not Allowed");
        }
        this.method = parts[0];
        try {
            this.url = new URL("http", EasyHttpd.getProperties().getHostName(), EasyHttpd.getProperties().getPortNumber(), parts[1]);
        }
        catch (MalformedURLException e) {
            throw new HttpProtocolException(400, "Bad Request");
        }
        if (parts[2].equals("HTTP/1.0")) {
            this.majorVersion = 1;
            this.minorVersion = 0;
            return;
        } else {
            if (!parts[2].equals("HTTP/1.1")) throw new HttpProtocolException(505, "HTTP Version Not Supported");
            this.majorVersion = 1;
            this.minorVersion = 1;
        }
    }

    private void putRequestHeader(String line) throws HttpProtocolException {
        EasyHttpd.getLogger().finest(line);
        if (line != null && line.length() > 0 && line.matches("[a-zA-Z0-9-]+: .+")) {
            String[] parts = line.split(":", 2);
            parts[0] = parts[0].toUpperCase();
            parts[1] = parts[1].trim();
            if (parts[0].equals(HEADER_CONNECTION.toUpperCase())) {
                this.header.put(HEADER_CONNECTION, parts[1]);
            } else if (parts[0].equals(HEADER_CONTENT_LENGTH.toUpperCase())) {
                try {
                    Integer length = new Integer(parts[1]);
                    this.header.put(HEADER_CONTENT_LENGTH, length);
                }
                catch (NumberFormatException e) {
                    throw new HttpProtocolException(400, "Bad Request");
                }
            } else if (parts[0].equals(HEADER_CONTENT_TYPE.toUpperCase())) {
                this.header.put(HEADER_CONTENT_TYPE, parts[1]);
            } else if (parts[0].equals(HEADER_HOST.toUpperCase())) {
                this.header.put(HEADER_HOST, parts[1]);
            } else if (parts[0].equals(HEADER_USER_AGENT.toUpperCase())) {
                this.header.put(HEADER_USER_AGENT, parts[1]);
            } else if (parts[0].equals(HEADER_IF_MODIFIED_SINCE.toUpperCase())) {
                SimpleDateFormat sdf = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.US);
                sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
                try {
                    Date date = sdf.parse(parts[1]);
                    this.header.put(HEADER_IF_MODIFIED_SINCE, date);
                }
                catch (ParseException e) {
                    throw new HttpProtocolException(400, "Bad Request");
                }
            }
        } else {
            throw new HttpProtocolException(400, "Bad Request");
        }
    }

    private String readLine(InputStream inputStream) throws IOException {
        int i = inputStream.read();
        if (i == -1) {
            throw new IOException();
        }
        char c = (char)i;
        StringBuffer s = new StringBuffer();
        while (c != '\n') {
            if (c != '\r') {
                s.append(c);
            }
            i = inputStream.read();
            c = (char)i;
        }
        return s.toString();
    }

    private int getContentLength() {
        return (Integer)this.header.get(HEADER_CONTENT_LENGTH);
    }

    private String getData() {
        if (this.data != null) {
            return new String(this.data);
        }
        return null;
    }

    public void init(InputStream inputStream) throws IOException, HttpProtocolException {
        EasyHttpd.getLogger().entering(this.getClass().getName(), "init(InputStream)");
        this.initFields();
        String line = this.readLine(inputStream);
        while (line == null || line.length() < 1) {
            line = this.readLine(inputStream);
        }
        this.parseRequestLine(line);
        line = this.readLine(inputStream);
        while (line != null && line.length() > 0) {
            this.putRequestHeader(line);
            line = this.readLine(inputStream);
        }
        if (this.method.equals("POST") && this.getContentLength() > 0) {
            this.data = new byte[this.getContentLength()];
            inputStream.read(this.data);
        }
        EasyHttpd.getLogger().fine(this.method + " " + this.url + " HTTP/" + this.majorVersion + "." + this.minorVersion + " " + this.header + " " + this.getData());
        EasyHttpd.getLogger().exiting(this.getClass().getName(), "init(InputStream)");
    }

    public String getRequestPath() {
        return this.url.getPath();
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public Date getIfModifierdSince() {
        return (Date)this.header.get(HEADER_IF_MODIFIED_SINCE);
    }

    public boolean isKeepAlive() {
        String connection = (String)this.header.get(HEADER_CONNECTION);
        if (connection == null || connection.length() < 1) {
            return false;
        }
        return "KEEP-ALIVE".equals(connection = connection.toUpperCase());
    }
}

