/*
 * Decompiled with CFR 0.152.
 */
package easyhttpd.http;

import easyhttpd.EasyHttpd;
import easyhttpd.http.HttpProtocolException;
import easyhttpd.http.HttpRequest;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.TimeZone;

public class HttpResponse {
    private static final String HEADER_CONNECTION = "Connection";
    private static final String HEADER_CONTENT_LENGTH = "Content-Length";
    private static final String HEADER_CONTENT_TYPE = "Content-Type";
    private static final String HEADER_DATE = "Date";
    private static final String HEADER_SERVER = "Server";
    private static final String HEADER_LAST_MODIFIED = "Last-Modified";
    private int statusCode;
    private String statusMessage;
    private int majorVersion;
    private int minorVersion;
    private HashMap header = new HashMap();
    private byte[] data;

    private void initFields() {
        this.statusCode = 0;
        this.statusMessage = null;
        this.majorVersion = 0;
        this.minorVersion = 0;
        this.header.clear();
        this.data = null;
    }

    private void loadFile(File file) throws HttpProtocolException {
        FileInputStream input = null;
        try {
            try {
                input = new FileInputStream(file);
                this.data = new byte[input.available()];
                input.read(this.data);
                this.header.put(HEADER_CONTENT_LENGTH, new Integer(this.data.length));
            }
            catch (FileNotFoundException e) {
                throw new HttpProtocolException(404, "Not Found");
            }
            catch (IOException e) {
                throw new HttpProtocolException(500, "Internal Server Error");
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            try {
                input.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        Object var4_7 = null;
        try {
            input.close();
        }
        catch (Exception e) {}
    }

    private void setContentType(File file) {
        String[] parts = file.getName().split("\\.");
        if (parts != null && parts.length > 1) {
            String extension = parts[parts.length - 1].toLowerCase();
            String mediaType = null;
            if (extension.equals("txt")) {
                mediaType = "text/plain";
            } else if (extension.equals("html") || extension.equals("htm")) {
                mediaType = "text/html";
            } else if (extension.equals("xml")) {
                mediaType = "text/xml";
            } else if (extension.equals("js")) {
                mediaType = "text/javascript";
            } else if (extension.equals("vbs")) {
                mediaType = "text/vbscript";
            } else if (extension.equals("css")) {
                mediaType = "text/css";
            } else if (extension.equals("gif")) {
                mediaType = "image/gif";
            } else if (extension.equals("jpg") || extension.equals("jpeg")) {
                mediaType = "image/jpeg";
            } else if (extension.equals("png")) {
                mediaType = "image/png";
            }
            this.header.put(HEADER_CONTENT_TYPE, mediaType);
        }
    }

    public void init(HttpRequest request) throws HttpProtocolException {
        EasyHttpd.getLogger().entering(this.getClass().getName(), "init(HttpRequest)");
        this.initFields();
        this.majorVersion = request.getMajorVersion();
        this.minorVersion = request.getMinorVersion();
        this.setKeepAlive(request.isKeepAlive());
        String documentRoot = EasyHttpd.getProperties().getDocumentRoot();
        File file = new File(documentRoot, request.getRequestPath());
        if (file.exists()) {
            if (file.isDirectory()) {
                file = new File(file, "index.html");
            }
            if (!file.exists()) {
                throw new HttpProtocolException(403, "Forbidden");
            }
        } else {
            throw new HttpProtocolException(404, "Not Found");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.US);
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        String fileLastModified = sdf.format(new Date(file.lastModified()));
        String requestIfModiredSince = null;
        if (request.getIfModifierdSince() != null) {
            requestIfModiredSince = sdf.format(request.getIfModifierdSince());
        }
        if (fileLastModified.equals(requestIfModiredSince)) {
            this.statusCode = 304;
            this.statusMessage = "Not Modified";
        } else {
            this.header.put(HEADER_LAST_MODIFIED, fileLastModified);
            this.setContentType(file);
            this.loadFile(file);
            this.statusCode = 200;
            this.statusMessage = "OK";
        }
        EasyHttpd.getLogger().fine("HTTP/" + this.majorVersion + "." + this.minorVersion + " " + this.statusCode + " " + this.statusMessage + " " + this.header + " " + file);
        EasyHttpd.getLogger().exiting(this.getClass().getName(), "init(HttpRequest)");
    }

    public void init(HttpProtocolException e) {
        this.initFields();
        this.majorVersion = 1;
        this.minorVersion = 0;
        this.statusCode = e.getErrorCode();
        this.statusMessage = e.getErrorMessage();
        this.setKeepAlive(false);
    }

    public void commit(OutputStream outputStream) throws IOException {
        byte[] buff;
        EasyHttpd.getLogger().entering(this.getClass().getName(), "commit(OutputStream)");
        SimpleDateFormat sdf = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.US);
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.header.put(HEADER_DATE, sdf.format(new Date()));
        this.header.put(HEADER_SERVER, EasyHttpd.getProperties().getApplicationName());
        StringBuffer headerBuff = new StringBuffer();
        headerBuff.append("HTTP/").append(this.majorVersion).append(".").append(this.minorVersion).append(" ").append(this.statusCode).append(" ").append(this.statusMessage).append("\r\n");
        Iterator i = this.header.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            headerBuff.append(key).append(": ").append(this.header.get(key)).append("\r\n");
        }
        headerBuff.append("\r\n");
        int headerLength = headerBuff.toString().getBytes().length;
        if (this.data != null && this.data.length > 0) {
            buff = new byte[headerLength + this.data.length];
            System.arraycopy(headerBuff.toString().getBytes(), 0, buff, 0, headerLength);
            System.arraycopy(this.data, 0, buff, headerLength, this.data.length);
        } else {
            buff = new byte[headerLength];
            System.arraycopy(headerBuff.toString().getBytes(), 0, buff, 0, headerLength);
        }
        outputStream.write(buff);
        outputStream.flush();
        EasyHttpd.getLogger().exiting(this.getClass().getName(), "commit(OutputStream)");
    }

    private void setKeepAlive(boolean keepAlive) {
        if (keepAlive) {
            this.header.put(HEADER_CONNECTION, "Keep-Alive");
        } else {
            this.header.put(HEADER_CONNECTION, "Close");
        }
    }

    public boolean isKeepAlive() {
        String connection = (String)this.header.get(HEADER_CONNECTION);
        if (connection == null || connection.length() < 1) {
            return false;
        }
        return "Keep-Alive".equals(connection);
    }
}

