/*
 * Decompiled with CFR 0.152.
 */
package easyhttpd.log;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class VerboseFormatter
extends Formatter {
    private Calendar calendar = Calendar.getInstance();
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS Z");

    public String format(LogRecord record) {
        StringBuffer message = new StringBuffer();
        message.append(this.sdf.format(new Date()));
        message.append(' ');
        message.append(record.getLevel().toString());
        message.append(' ');
        message.append(Thread.currentThread().getName());
        message.append(' ');
        if (record.getSourceClassName() != null) {
            message.append(record.getSourceClassName());
        } else {
            message.append(record.getLoggerName());
        }
        message.append(' ');
        if (record.getSourceMethodName() != null) {
            message.append('[').append(record.getSourceMethodName()).append(']');
        }
        message.append(' ');
        message.append("- ").append(this.formatMessage(record));
        message.append('\n');
        if (record.getThrown() != null) {
            message.append(record.getThrown()).append('\n');
            StackTraceElement[] elements = record.getThrown().getStackTrace();
            int i = 0;
            while (i < elements.length) {
                message.append('\t').append("at ").append(elements[i].toString()).append('\n');
                ++i;
            }
        }
        return message.toString();
    }
}

