/*
 * Decompiled with CFR 0.152.
 */
package easyhttpd.tcp;

import easyhttpd.EasyHttpd;
import easyhttpd.http.HttpService;
import easyhttpd.tcp.TcpThreadCounter;
import java.net.ServerSocket;
import java.util.logging.Level;

public class TcpServer {
    public void start() {
        try {
            ServerSocket serverSocket = new ServerSocket(EasyHttpd.getProperties().getPortNumber());
            EasyHttpd.getLogger().info("Listening... (port=" + serverSocket.getLocalPort() + ")");
            try {
                TcpThreadCounter counter = new TcpThreadCounter();
                int maxThreadCount = EasyHttpd.getProperties().getMaxThreadCount();
                HttpService service = null;
                Thread thread = null;
                while (true) {
                    if (counter.getCount() >= maxThreadCount) {
                        continue;
                    }
                    counter.increase();
                    service = new HttpService(serverSocket.accept(), counter);
                    thread = new Thread(service);
                    thread.start();
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    serverSocket.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            EasyHttpd.getLogger().log(Level.SEVERE, e.getMessage(), e);
            return;
        }
    }
}

