/*
 * 쐬: 2004/05/28
 *
 * $Id: Properties.java,v 1.6 2004/06/13 17:00:27 yz125_97 Exp $
 * 

Copyright (c) 2004, Naomine Egawa.
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

1. Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer. 
   Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution. 

2. Neither the name of the EasyHttpd project nor the names of its
   contributors may be used to endorse or promote products derived from
   this software without specific prior written permission. 

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

 */
package easyhttpd;

import java.util.ResourceBundle;

public final class Properties {
	private final String applicationName;
	private final String hostName;
	private final int portNumber;
	private final int maxThreadCount;
	private final String documentRoot;
	private final int keepAliveTimeout;

	public Properties() {
		ResourceBundle resource = ResourceBundle.getBundle("EasyHttpd");
		applicationName = resource.getString("applicationName");
		hostName = resource.getString("hostName");
		portNumber = Integer.parseInt(resource.getString("portNumber"));
		maxThreadCount = Integer.parseInt(resource.getString("maxThreadCount"));
		documentRoot = resource.getString("documentRoot");
		keepAliveTimeout =
			Integer.parseInt(resource.getString("keepAliveTimeout"));
		EasyHttpd.getLogger().config(
			new StringBuffer("{")
				.append("ApplicationName=")
				.append(applicationName)
				.append(", ")
				.append("HostName=")
				.append(hostName)
				.append(", ")
				.append("PortNumber=")
				.append(portNumber)
				.append(", ")
				.append("MxThreadCount=")
				.append(maxThreadCount)
				.append(", ")
				.append("DcumentRoot=")
				.append(documentRoot)
				.append(", ")
				.append("KepAliveTimeout=")
				.append(keepAliveTimeout)
				.append("}")
				.toString());
	}

	public String getHostName() {
		return hostName;
	}

	public int getMaxThreadCount() {
		return maxThreadCount;
	}

	public int getPortNumber() {
		return portNumber;
	}

	public String getDocumentRoot() {
		return documentRoot;
	}

	public int getKeepAliveTimeout() {
		return keepAliveTimeout;
	}

	public String getApplicationName() {
		return applicationName;
	}
}
