/*
 * 쐬: 2004/05/28
 *
 * $Id: HttpService.java,v 1.7 2004/06/13 17:00:27 yz125_97 Exp $
 * 

Copyright (c) 2004, Naomine Egawa.
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

1. Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer. 
   Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution. 

2. Neither the name of the EasyHttpd project nor the names of its
   contributors may be used to endorse or promote products derived from
   this software without specific prior written permission. 

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

 */
package easyhttpd.http;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.logging.Level;

import easyhttpd.EasyHttpd;
import easyhttpd.tcp.TcpThreadCounter;

public class HttpService implements Runnable {
	private final Socket clientSocket;
	private final TcpThreadCounter counter;

	public HttpService(Socket clientSocket, TcpThreadCounter counter) {
		this.clientSocket = clientSocket;
		this.counter = counter;
	}

	public void run() {
		EasyHttpd.getLogger().entering(this.getClass().getName(), "run()");
		try {
			HttpRequest request = new HttpRequest();
			HttpResponse response = new HttpResponse();
			final int keepAliveTimeout =
				EasyHttpd.getProperties().getKeepAliveTimeout();
			clientSocket.setSoTimeout(keepAliveTimeout);
			while (true) {
				try {
					request.init(clientSocket.getInputStream());
					response.init(request);
				} catch (HttpProtocolException e) {
					response.init(e);
					EasyHttpd.getLogger().log(Level.WARNING, e.getMessage(), e);
				}
				response.commit(clientSocket.getOutputStream());
				if (!response.isKeepAlive()
					|| request.getMinorVersion() != 1) {
					break;
				}
			}
		} catch (SocketTimeoutException e) {
		} catch (IOException e) {
		} finally {
			try {
				clientSocket.close();
			} catch (Exception e) {
			}
			counter.decrease();
		}
		EasyHttpd.getLogger().exiting(this.getClass().getName(), "run()");
	}
}
