/*
 * 쐬: 2004/05/28
 *
 * $Id: TcpServer.java,v 1.5 2004/06/13 17:00:27 yz125_97 Exp $
 * 

Copyright (c) 2004, Naomine Egawa.
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

1. Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer. 
   Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution. 

2. Neither the name of the EasyHttpd project nor the names of its
   contributors may be used to endorse or promote products derived from
   this software without specific prior written permission. 

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

 */
package easyhttpd.tcp;

import java.net.ServerSocket;
import java.util.logging.Level;

import easyhttpd.EasyHttpd;
import easyhttpd.http.HttpService;

public class TcpServer {
	public void start() {
		try {
			final ServerSocket serverSocket =
				new ServerSocket(EasyHttpd.getProperties().getPortNumber());
			EasyHttpd.getLogger().info(
				new StringBuffer("Listening... (port=")
					.append(serverSocket.getLocalPort())
					.append(")")
					.toString());
			try {
				final TcpThreadCounter counter = new TcpThreadCounter();
				final int maxThreadCount =
					EasyHttpd.getProperties().getMaxThreadCount();
				HttpService service = null;
				Thread thread = null;
				while (true) {
					if (counter.getCount() < maxThreadCount) {
						counter.increase();
						service =
							new HttpService(serverSocket.accept(), counter);
						thread = new Thread(service);
						thread.start();
					}
				}
			} finally {
				try {
					serverSocket.close();
				} catch (Exception e) {
				}
			}
		} catch (Exception e) {
			EasyHttpd.getLogger().log(Level.SEVERE, e.getMessage(), e);
		}
	}
}
