<?php
require_once (__FILE__ . "/../" . "include.php");

class FieldUtils {

	function typeCheck($fieldName, $fieldValue) {
		$fieldTypeString = $fieldName == "id" ?
			$fieldName :
			substr($fieldName, 0, 1);
		if ($fieldTypeString == "id" ||
			$fieldTypeString == "i" ||
			$fieldTypeString == "d" ||
			$fieldTypeString == "t" ||
			$fieldTypeString == "b") {
			return $fieldValue == null ||
				is_numeric($fieldValue);	
		}
		else if ($fieldTypeString == "s") {
			return $fieldValue == null ||
				is_string($fieldValue);
		}
	}
	
	function isString($fieldName) {
		return FieldUtils::getFieldTypeString($fieldName) == "s";
	}
	
	function isTimestamp($fieldName) {
		return FieldUtils::getFieldTypeString($fieldName) == "t";
	}
	
	function getFieldTypeString($fieldName) {
		return $fieldTypeString = $fieldName == "id" ?
			$fieldName :
			substr($fieldName, 0, 1);
	}
}
?>