<?php
require_once (__FILE__ . "/../" . "include.php");

class ORMapper {

	function setup($object) {
		DatabaseManager::doUpdateQuery(ORMapperQuery::getCreateTableQuery($object));
	}

    function saveOrUpdate($object) {
    		if (isset($object->id) && is_numeric($object->id)) {
    			DatabaseManager::doUpdateQuery(ORMapperQuery::getUpdateQuery($object));
    		}
    		else {
    			DatabaseManager::doUpdateQuery(ORMapperQuery::getInsertQuery($object));
    		}
    }
    
    function delete($object) {
		DatabaseManager::doUpdateQuery(ORMapperQuery::getDeleteQuery($object));
    }
    
    function select($object,
		$whereQuery,
		$orderColumnName,
		$isOrderReverse = false,
		$limit,
		$offset = 0) {
    		return DatabaseManager::doSelectQuery(ORMapperQuery::getSelectQuery($object,
			$whereQuery,
			$orderColumnName,
			$isOrderReverse,
			$limit,
			$offset));	
    }
    
}
?>