<?php
require_once (__FILE__ . "/../" . "include.php");

class ORMapperQuery {

	function getCreateTableQuery($object) {
		$query = new Query(get_class($object));
		$vars = get_object_vars($object);
		foreach ($vars as $varsName => $varsValue) {
			$query->addColumn($varsName, ORMapperQuery::getColumnType($varsName));
		}
		return $query->getCreateTableQuery();
	}
	
	function getUpdateQuery($object, $whereQuery) {
		$query = new Query(get_class($object));
		$vars = get_object_vars($object);
		foreach ($vars as $varsName => $varsValue) {
			$query->addUpdateValue($varsName, ORMapperQuery::convertFieldValue($varsName, $varsValue));
		}
		if ($whereQuery != undefined) {
			$query->setWhereQuery($whereQuery->getWhereQueryObject());
		}
		else {
			$whereQuery = new ORMapperQuery($object);
			$whereQuery->addEqualsAnd("id", $object->id);
			$query->setWhereQuery($whereQuery->getWhereQueryObject());
		}
		return $query->getUpdateQuery();
	}
	
	function getInsertQuery($object) {
		$query = new Query(get_class($object));
		$vars = get_object_vars($object);
		foreach ($vars as $varsName => $varsValue) {
			$query->addInsertValue($varsName, ORMapperQuery::convertFieldValue($varsName, $varsValue));
		}
		return $query->getInsertQuery();
	}
	
	function getDeleteQuery($object, $whereQuery) {
		$query = new Query(get_class($object));
		if ($whereQuery != undefined) {
			$query->setWhereQuery($whereQuery->getWhereQueryObject());
		}
		else {
			$whereQuery = new ORMapperQuery($object);
			$whereQuery->addEqualsAnd("id", $object->id);
			$query->setWhereQuery($whereQuery->getWhereQueryObject());
		}
		return $query->getDeleteQuery();
	}
	
	function getSelectQuery($object,
		$whereQuery,
		$orderColumnName,
		$isOrderReverse = false,
		$limit,
		$offset = 0) {
		$query = new Query(get_class($object));
		if ($whereQuery != undefined) {
			$query->setWhereQuery($whereQuery->getWhereQueryObject());
		}
		if ($orderColumnName != undefined) {
			$query->setOrderBy($orderColumnName, $isOrderReverse);
		}
		if ($limit != undefined) {
			$query->setLimit($limit, $offset);
		}
		return $query->getSelectQuery();
	}
	
	function convertFieldValue($fieldName, $fieldValue) {
		return FieldUtils::isString($fieldName) ?
			Query::getQueryStringValue($fieldValue) :
			(FieldUtils::isTimestamp($fieldName) ?
			Query::getDateString($fieldValue) :
			$fieldValue);
	}

	function getColumnType($columnName) {
		$columnTypeString = $columnName == "id" ?
			$columnName :
			substr($columnName, 0, 1);
		$COLUMN_TYPE_MAP = array(
			"id" => "bigint(20) not NULL primary key AUTO_INCREMENT", 
			"s" => "varchar(255)",
			"d" => "bigint(20)",
			"i" => "int(11)",
			"b" => "tinyint(1)",
			"t" => "timestamp");
		return $COLUMN_TYPE_MAP[$columnTypeString];
	}
}
?>