<?php
require_once (__FILE__ . "/../" . "include.php");

class ORMapperQueryWhere {

	var $object;
	var $objectVars;
	var $queryWhere;

    function ORMapperQueryWhere($object) {
		$this->queryWhere = new QueryWhere();
		$this->object = $object;
		$this->objectVars = get_object_vars($object);
    }
    
    function addEqualsAnd($fieldName, $value) {
    		$queryWhere = $this->queryWhere;
		switch (FieldUtils::typeCheck($fieldName)) {
			case "s":
				$queryWhere->addStringEqualsAnd($fieldName, $value);
				break;
			case "t":
				$queryWhere->addTimestampEqualsAnd($fieldName, $value);
				break;
			case "id":
			case "i":
			case "d":
			case "b":
			default:
				$queryWhere->addNumericEqualsAnd($fieldName, $value);
				break;
		}
    }
    function addEqualsOr($fieldName, $value) {
		$queryWhere = $this->queryWhere;
		switch (FieldUtils::typeCheck($fieldName)) {
			case "s":
				$queryWhere->addStringEqualsOr($fieldName, $value);
				break;
			case "t":
				$queryWhere->addTimestampEqualsOr($fieldName, $value);
				break;
			case "id":
			case "i":
			case "d":
			case "b":
			default:
				$queryWhere->addNumericEqualsOr($fieldName, $value);
				break;
		}
    }
    function addLikeAnd($fieldName, $value) {
    		$queryWhere = $this->queryWhere;
		switch (FieldUtils::typeCheck($fieldName)) {
			case "s":
				$queryWhere->addStringLikeAnd($fieldName, $value);
				break;
			case "t":
				trigger_error(ORMapperErrorMessages::faultQueryWhere(), E_USER_WARNING);
				break;
			case "id":
			case "i":
			case "d":
			case "b":
			default:
				trigger_error(ORMapperErrorMessages::faultQueryWhere(), E_USER_WARNING);
				break;
		}
    }
    function addLikeOr($fieldName, $value) {
		$queryWhere = $this->queryWhere;
		switch (FieldUtils::typeCheck($fieldName)) {
			case "s":
				$queryWhere->addStringLikeOr($fieldName, $value);
				break;
			case "t":
				trigger_error(ORMapperErrorMessages::faultQueryWhere(), E_USER_WARNING);
				break;
			case "id":
			case "i":
			case "d":
			case "b":
			default:
				trigger_error(ORMapperErrorMessages::faultQueryWhere(), E_USER_WARNING);
				break;
		}
    }
    function addGreaterAnd($fieldName, $value) {
		$queryWhere = $this->queryWhere;
		switch (FieldUtils::typeCheck($fieldName)) {
			case "s":
				trigger_error(ORMapperErrorMessages::faultQueryWhere(), E_USER_WARNING);
				break;
			case "t":
				$queryWhere->addTimestampGreaterAnd($fieldName, $value);
				break;
			case "id":
			case "i":
			case "d":
			case "b":
			default:
				$queryWhere->addNumericGreaterAnd($fieldName, $value);
				break;
		}
    }
    function addGreaterOr($fieldName, $value) {
		$queryWhere = $this->queryWhere;
		switch (FieldUtils::typeCheck($fieldName)) {
			case "s":
				trigger_error(ORMapperErrorMessages::faultQueryWhere(), E_USER_WARNING);
				break;
			case "t":
				$queryWhere->addTimestampGreaterOr($fieldName, $value);
				break;
			case "id":
			case "i":
			case "d":
			case "b":
			default:
				$queryWhere->addNumericGreaterOr($fieldName, $value);
				break;
		}
    }
    function addLessAnd($fieldName, $value) {
		$queryWhere = $this->queryWhere;
		switch (FieldUtils::typeCheck($fieldName)) {
			case "s":
				trigger_error(ORMapperErrorMessages::faultQueryWhere(), E_USER_WARNING);
				break;
			case "t":
				$queryWhere->addTimestampLessAnd($fieldName, $value);
				break;
			case "id":
			case "i":
			case "d":
			case "b":
			default:
				$queryWhere->addNumericLessAnd($fieldName, $value);
				break;
		}
    }
    function addLessOr($fieldName, $value) {
		$queryWhere = $this->queryWhere;
		switch (FieldUtils::typeCheck($fieldName)) {
			case "s":
				trigger_error(ORMapperErrorMessages::faultQueryWhere(), E_USER_WARNING);
				break;
			case "t":
				$queryWhere->addTimestampLessOr($fieldName, $value);
				break;
			case "id":
			case "i":
			case "d":
			case "b":
			default:
				$queryWhere->addNumericLessOr($fieldName, $value);
				break;
		}
    }
    function getWhereQueryObject() {
    		return $this->queryWhere;
    }
}
?>