<?php
require_once (__FILE__ . "/../" . "include.php");
class Query {
	var $tableName;
	var $createTableQuery;
	var $whereQuery;
	var $orderBy;
	var $limit;
	var $updateSetQuery;
	var $insertColumnQuery;
	var $insertValueQuery;
	function Query($tableName) {
		$this->tableName = $tableName;
		$this->createTableQuery = "";
		$this->whereQuery = null;
		$this->orderBy = "";
		$this->limit = "";
		$this->updateSetQuery = "";
		$this->insertColumnQuery = "";
		$this->insertValueQuery = "";
	}
	function getTargetObject() {
		return $this->targetObject;
	}
	function addColumn($columnName, $createDifinition) {
		if ($this->createTableQuery != "") {
			$this->createTableQuery .= ", ";
		}
		$this->createTableQuery .= $columnName;
		$this->createTableQuery .= " ";
		$this->createTableQuery .= $createDifinition;
	}
	function setWhereQuery($whereQuery) {
		$this->whereQuery = $whereQuery;
	}
	function setOrderBy($columnName, $isReverse = false) {
		$this->orderBy = $columnName;
		if ($isReverse) {
			$this->orderBy += 'desc';
		}
	}
	function setLimit($limit, $offset = 0) {
		$this->limit = $offset . ', ' . $limit;
	}
	function addUpdateValue($columnName, $value) {
		if (isset($columnName) && isset($value)) {
			if ($this->updateSetQuery != "") {
				$this->updateSetQuery .= ", ";
			}
			$this->updateSetQuery .= $columnName;
			$this->updateSetQuery .= "=";
			$this->updateSetQuery .= $value;
		}
	}
	function addInsertValue($columnName, $value) {
		if (isset($columnName) && isset($value)) {		
			if ($this->insertColumnQuery != "") {
				$this->insertColumnQuery .= ", ";
			}
			$this->insertColumnQuery .= $columnName;
			if ($this->insertValueQuery != "") {
				$this->insertValueQuery .= ", ";
			}
			$this->insertValueQuery .= $value;
		}
	}
	function getCreateTableQuery() {
		$createTableQuery = 'create table if not exists ';
		$createTableQuery .= $this->tableName;
		$createTableQuery .= ' (';
		$createTableQuery .= $this->createTableQuery;
		$createTableQuery .= ')';
		return $createTableQuery;
	}
	function getSelectQuery() {
		$selectQuery = 'select * from ';
		$selectQuery .= $this->tableName;
		if ($this->whereQuery != null) {
			$selectQuery .= ' where ';
			$selectQuery .= $this->whereQuery->getWhereQuery();
		}
		if ($this->orderBy != "") {
			$selectQuery .= ' order by ';
			$selectQuery .= $this->orderBy;
		}
		if ($this->limit != "") {
			$selectQuery .= ' limit ';
			$selectQuery .= $this->limit;
		}
		return $selectQuery;
	}
	function getInsertQuery() {
		$insertQuery = 'insert into ';
		$insertQuery .= $this->tableName;
		$insertQuery .= ' (';
		$insertQuery .= $this->insertColumnQuery;
		$insertQuery .= ') values (';
		$insertQuery .= $this->insertValueQuery;
		$insertQuery .= ')';
		return $insertQuery;
	}
	function getUpdateQuery() {
		$updateQuery = 'update ';
		$updateQuery .= $this->tableName;
		$updateQuery .= ' set ';
		$updateQuery .= $this->updateSetQuery;
		if ($this->whereQuery != null) {
			$updateQuery .= ' where ';
			$updateQuery .= $this->whereQuery->getWhereQuery();
		}
		return $updateQuery;
	}
	function getDeleteQuery() {
		$deleteQuery = 'delete from ';
		$deleteQuery .= $this->tableName;
		if ($this->whereQuery != null) {
			$deleteQuery .= ' where ';
			$deleteQuery .= $this->whereQuery->getWhereQuery();
		}
		return $deleteQuery;
	}
	function getQueryStringValue($value) {
		return "'" . $value . "'";
	}
	function convertQueryValue($value) {
		
	}
	function getDateString($timestamp) {
		return Query :: getQueryStringValue(date('Y-m-d H:i:s', $timestamp));
	}
}
?>