
#include "defs.h"
#include "dicts.h"
#include "dictbar.h"
#include "mainwnd.h"

static void dictbar_toggled(GtkWidget *widget, gpointer data)
{
    BOOK_INFO *binfo = (BOOK_INFO*)data;
    binfo->active = gtk_toggle_tool_button_get_active(GTK_TOGGLE_TOOL_BUTTON(widget));
    dicts_save();
}

gboolean dictbar_get_group(GtkTreeIter *iter)
{
    int i, n = gtk_combo_box_get_active(GTK_COMBO_BOX(dictbar.combo));
    GtkTreeIter iter1;
    if(!gtk_tree_model_get_iter_first(GTK_TREE_MODEL(dicts.store), &iter1))
	return FALSE;
    for(i = 0; i < n; i++)
    {
	if(!gtk_tree_model_iter_next(GTK_TREE_MODEL(dicts.store), &iter1))
	    return FALSE;
    }
    if(!gtk_tree_model_iter_children(GTK_TREE_MODEL(dicts.store), iter, &iter1))
	return FALSE;

    return TRUE;
}

static void dictbar_buttons_add()
{
    gchar *title;
    GtkTreeIter iter;
    GtkToolItem *toggle;
    BOOK_INFO *binfo;
    if(!dictbar_get_group(&iter))
	return;
    gtk_widget_hide(GTK_WIDGET(dictbar.bar));
    do {
	gtk_tree_model_get(GTK_TREE_MODEL(dicts.store), &iter, DICT_ALIAS, &title, DICT_BINFO, &binfo, -1);

	toggle = gtk_toggle_tool_button_new();
	gtk_tool_button_set_label(GTK_TOOL_BUTTON(toggle), title);
	gtk_toggle_tool_button_set_active(GTK_TOGGLE_TOOL_BUTTON(toggle), binfo->active);
	gtk_tool_item_set_homogeneous(toggle, FALSE);
	g_signal_connect(G_OBJECT(toggle),"toggled", G_CALLBACK(dictbar_toggled), (gpointer)binfo);

	gtk_toolbar_insert(GTK_TOOLBAR(dictbar.bar), toggle, -1);
	if(!binfo->available)
	    gtk_widget_set_sensitive(GTK_WIDGET(toggle), FALSE);
	gtk_widget_set_tooltip_text(GTK_WIDGET(toggle), title);

	g_free(title);
	if(!gtk_tree_model_iter_next(GTK_TREE_MODEL(dicts.store), &iter))
	    break;
	gtk_toolbar_insert(GTK_TOOLBAR(dictbar.bar), gtk_separator_tool_item_new(), -1);
    } while(TRUE);
    gtk_widget_show_all(GTK_WIDGET(dictbar.bar));
}

static void dictbar_button_remove(GtkWidget *w, gpointer data)
{
    if(GTK_IS_TOOL_ITEM(w))
	gtk_container_remove(GTK_CONTAINER(dictbar.bar), w);
}

static void dictbar_buttons_remove()
{
    gtk_widget_hide(GTK_WIDGET(dictbar.bar));
    gtk_container_forall(GTK_CONTAINER(dictbar.bar), dictbar_button_remove, NULL);
    gtk_widget_show_all(GTK_WIDGET(dictbar.bar));
}

static void dictbar_buttons_update()
{
    dictbar_buttons_remove();
    dictbar_buttons_add();
}

static gint dictbar_group_changed(GtkWidget *combo)
{
    dictbar_buttons_update();
    dicts_save();
    return 0;
}

void dictbar_add_combo_entries()
{
    GtkTreeIter iter;
    if(gtk_tree_model_get_iter_first(GTK_TREE_MODEL(dicts.store), &iter))
    {
	do { 
	    gchar *title;
	    gtk_tree_model_get(GTK_TREE_MODEL(dicts.store), &iter, DICT_ALIAS, &title, -1);
	    gtk_combo_box_append_text(GTK_COMBO_BOX(dictbar.combo), title);
	    g_free(title);
	} while(gtk_tree_model_iter_next(GTK_TREE_MODEL(dicts.store), &iter));
    }
    my_gtk_combo_box_set_active_text(GTK_COMBO_BOX(dictbar.combo), dictbar.group);
    g_free(dictbar.group);
    dictbar.group = NULL;
}

GtkWidget *dictbar_create()
{
    dictbar.hbox = gtk_hbox_new(FALSE, 5);
    gtk_container_set_border_width(GTK_CONTAINER(dictbar.hbox), 3);

    dictbar.combo = gtk_combo_box_new_text();
    gtk_widget_set_size_request(dictbar.combo, 200, -1);
    gtk_box_pack_start(GTK_BOX(dictbar.hbox), dictbar.combo, FALSE, FALSE, 0);
    gtk_widget_set_tooltip_text(dictbar.combo, "Select dictionary group.");

    dictbar_add_combo_entries();
    g_signal_connect(G_OBJECT(dictbar.combo), "changed", G_CALLBACK(dictbar_group_changed), NULL);

    dictbar.bar = gtk_toolbar_new();
    gtk_box_pack_start(GTK_BOX(dictbar.hbox), dictbar.bar, TRUE, TRUE, 0);
    //gchar *s = g_strdup_printf("style \"custom-shadow\"{GtkToolbar::shadow-type=GTK_SHADOW_NONE}\nclass \"GtkToolbar\" style \"custom-font\"");
    gtk_rc_parse_string("style \"custom-shadow\"{ \n \
	    GtkToolbar::shadow-type=GTK_SHADOW_NONE} \n \
	    class \"GtkToolbar\" style \"custom-shadow\"");
    GdkScreen *screen = gtk_window_get_screen(GTK_WINDOW(mainwnd.wnd));
    GtkSettings *settings = gtk_settings_get_for_screen(screen);
    gtk_rc_reset_styles(settings);

    dictbar_buttons_add();
    gtk_widget_show_all(dictbar.hbox);
    return dictbar.hbox;
}

void dictbar_update()
{
    gchar *text = gtk_combo_box_get_active_text(GTK_COMBO_BOX(dictbar.combo));
    GtkTreeModel *model = gtk_combo_box_get_model(GTK_COMBO_BOX(dictbar.combo));
    gtk_widget_hide(dictbar.bar);
    dictbar_buttons_remove();
    while(gtk_tree_model_iter_n_children(model, NULL))
	gtk_combo_box_remove_text(GTK_COMBO_BOX(dictbar.combo), 0);
    dictbar_add_combo_entries();
    gtk_combo_box_set_active(GTK_COMBO_BOX(dictbar.combo), 0);
    my_gtk_combo_box_set_active_text(GTK_COMBO_BOX(dictbar.combo), text);
    gtk_widget_show_all(dictbar.bar);
    g_free(text);
}

static void dictbar_btn_select(GtkWidget *widget, gpointer data)
{
    if(GTK_IS_TOGGLE_TOOL_BUTTON(widget))
	gtk_toggle_tool_button_set_active(GTK_TOGGLE_TOOL_BUTTON(widget), TRUE);
}

static void dictbar_btn_unselect(GtkWidget *widget, gpointer data)
{
    if(GTK_IS_TOGGLE_TOOL_BUTTON(widget))
	gtk_toggle_tool_button_set_active(GTK_TOGGLE_TOOL_BUTTON(widget), FALSE);
}

void dictbar_all_select()
{
    gtk_container_foreach(GTK_CONTAINER(dictbar.bar), dictbar_btn_select, NULL);
}

void dictbar_all_unselect()
{
    gtk_container_foreach(GTK_CONTAINER(dictbar.bar), dictbar_btn_unselect, NULL);
}

