
#define _GLOBAL
#include <sys/wait.h>

#include "defs.h"

#include "dictbar.h"
#include "dicts.h"
#include "headword.h"
#include "history.h"
#include "hook.h"
#include "mainwnd.h"
#include "preferences.h"
#include "selection.h"
#include "hotkeys.h"
#include "textview.h"

#ifdef ENABLE_GSTREAMER
#include <gst/gst.h>
#endif

void app_exit(GtkWidget *widget, gpointer   data)
{
    hooksets_finalize();

    gdk_window_get_root_origin(mainwnd.wnd->window, &mainwnd.x, &mainwnd.y);
    mainwnd.w = mainwnd.wnd->allocation.width;
    mainwnd.h = mainwnd.wnd->allocation.height;

    paned.treew = paned.tree->allocation.width;
    paned.treeh = paned.tree->allocation.height;

    history_save_words();
    preferences_save();
    dicts_save();
    hotkeys_save();
    gtk_main_quit ();
}

void app_quit()
{
    app_exit(NULL, NULL);
}

gchar* app_browse_disk(gchar* title, GtkWindow *wnd, gint action, gchar *btn_text, gchar *path)
{
    gchar *res = NULL;
    GtkWidget *dlg = gtk_file_chooser_dialog_new(title, wnd, action, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, btn_text, GTK_RESPONSE_ACCEPT, NULL);
    if(path)
    {
        gtk_file_chooser_set_current_folder(GTK_FILE_CHOOSER(dlg), path);
        g_free(path);
    }
    if(gtk_dialog_run(GTK_DIALOG(dlg)) == GTK_RESPONSE_ACCEPT)
        res = gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(dlg));
    gtk_widget_destroy(dlg);
    return res;
}

int main(int argc, char *argv[])
{
    gtk_init(&argc, &argv);

#ifdef ENABLE_GSTREAMER
    gst_init(&argc, &argv);
#endif

#ifdef ENABLE_NLS
    bindtextdomain(PACKAGE_NAME, LOCALEDIR);
    bind_textdomain_codeset(PACKAGE_NAME, ENC_UTF8);
    textdomain(PACKAGE_NAME);
#endif

    preferences_init();
    eb_initialize_library();
    hooksets_init();

    preferences_load();
    dicts_load();
    history_load_words();
    hotkeys_load();

    mainwnd_create();

    gtk_main();
    hooksets_finalize();

    _exit(0);
}

