
#include "defs.h"
#include "eb123.h"
#include "ebook.h"
#include "headwordrender.h"
#include "mainwnd.h"
#include "render.h"

G_DEFINE_TYPE(EbHeadwordRender, eb_headword_render, GTK_TYPE_CELL_RENDERER);

static gpointer eb_headword_render_parent_class_ptr = NULL;

enum
{
    HWR_PROP_0,
    HWR_PROP_TEXT,
    HWR_PROP_RESULT,
};

static void eb_headword_render_set_property(GObject *object, guint param_id, const GValue *value, GParamSpec *pspec)
{
    EbHeadwordRender *r = EB_HEADWORD_RENDER(object);

    switch(param_id)
    {
	case HWR_PROP_TEXT:
	    if(r->text)
		g_free(r->text);
	    r->text = g_strdup(g_value_get_string(value));
	    break;
	case HWR_PROP_RESULT:
	    r->res = ((RESULT*)g_value_get_pointer(value));
	    break;
	default:
	    G_OBJECT_WARN_INVALID_PROPERTY_ID(object, param_id, pspec);
	    break;
    }
}

static void eb_headword_render_get_property(GObject *object, guint param_id, GValue *value, GParamSpec *pspec)
{
    EbHeadwordRender *r = EB_HEADWORD_RENDER(object);

    switch (param_id)
    {
	case HWR_PROP_TEXT:
	    g_value_set_string(value, r->text);
	    break;
	case HWR_PROP_RESULT:
	    g_value_set_pointer(value, r->res);
	    break;
	default:
	    G_OBJECT_WARN_INVALID_PROPERTY_ID (object, param_id, pspec);
	    break;
    }
}

static void eb_headword_render_get_size(GtkCellRenderer *cell, GtkWidget *widget, GdkRectangle *area, gint *x_offset, gint *y_offset, gint *w, gint *h)
{
    if(w)
	*w = 100;
    if(h)
    {
	if(!GTK_IS_WIDGET(widget))
	    return;
	GtkStyle *style = gtk_widget_get_style(widget);
	*h = 2*pango_font_description_get_size(style->font_desc)/PANGO_SCALE;
    }
    if(x_offset)
	*x_offset = 2;
    if(y_offset)
	*y_offset = 2;
}

#if 0
static void eb_headword_render_string(GtkCellRenderer *cell,
	GdkWindow *window,
	GtkWidget *widget,
	GtkStateType state,
	gchar *text,
	gint length,
	gint *x, gint *y,
	gboolean render)
{
}
#endif

typedef struct _eb_headword_render_ctx
{
    guint x, y;
    GdkWindow *window;
    GtkWidget *widget;
    GtkCellRendererState flags;
    EbHeadwordRender *r;
} eb_headword_render_ctx;

static void eb_headword_render_startElement(void *ctx, const xmlChar *name, const xmlChar **atts)
{
    eb_headword_render_ctx *my = (eb_headword_render_ctx*)ctx;
    if(!g_strcmp0((gchar*)name, "gaiji"))
    {
	gint w, h, x_offset, y_offset;;
	GtkStateType state = (my->flags & GTK_CELL_RENDERER_SELECTED) ? GTK_STATE_SELECTED : GTK_STATE_NORMAL;
	gchar *spec = gtk_color_selection_palette_to_string(&(my->widget->style->fg[state]), 1);
	GdkPixbuf *pixbuf;
	GdkGC *gc = gdk_gc_new(my->window);
	GdkColor color;
	gdk_color_parse(spec, &color);
	if(spec) g_free(spec);
#if 0
	gdk_gc_set_foreground(gc, &color);
	gdk_gc_set_rgb_fg_color(gc, &color);
	gdk_gc_set_fill(gc, GDK_OPAQUE_STIPPLED);
#endif
	eb_headword_render_get_size(NULL, my->widget, NULL, &x_offset, &y_offset, NULL, NULL);
	if((pixbuf = ebook_read_gaiji(my->r->res->binfo, (gchar*)atts[1], &w, &h)))
	{
	    gdk_draw_pixbuf(my->window, gc, pixbuf, 0, 0, my->x, my->y, w, h + y_offset, GDK_RGB_DITHER_NORMAL, 0, 0);
	    my->x += w + x_offset;
	}
	g_object_unref(gc);
	gdk_pixbuf_unref(pixbuf);
    }
}

static void eb_headword_render_characters(void *ctx, const xmlChar *ch, int len)
{
    eb_headword_render_ctx *my = (eb_headword_render_ctx*)ctx;
    gint x_offset = my->x, y_offset = my->y;
    gchar *str, *tmp, *spec, *text;
    GtkStateType state;
    PangoAttrList *attrs;
    PangoLayout *layout;
    PangoRectangle rect;
    state = (my->flags & GTK_CELL_RENDERER_SELECTED) ? GTK_STATE_SELECTED : GTK_STATE_NORMAL;
    spec = gtk_color_selection_palette_to_string(&(my->widget->style->fg[state]), 1);
    str = g_strdup((gchar*)ch);
    tmp = str;
    str = g_strdup_printf("<span foreground=\"%s\">%s</span>", spec, tmp);
    g_free(tmp);
    pango_parse_markup(str, -1, 0, &attrs, &text, NULL, NULL);
    if(text)
    {
	layout = gtk_widget_create_pango_layout(my->widget, text);
	pango_layout_set_attributes(layout, attrs);
    }
    else
	layout = gtk_widget_create_pango_layout(my->widget, str);
    pango_layout_get_pixel_extents (layout, NULL, &rect);
    gdk_draw_layout(my->window, my->widget->style->fg_gc[GTK_WIDGET_STATE(my->widget)], x_offset, y_offset, layout);
    my->x += rect.width;
    if(str) g_free(str);
    if(spec) g_free(spec);
}

static void eb_headword_render(GtkCellRenderer      *cell,
	 GdkWindow            *window,
	 GtkWidget            *widget,
	 GdkRectangle         *background_area,
	 GdkRectangle         *cell_area,
	 GdkRectangle         *expose_area,
	 GtkCellRendererState  flags)
{
    EbHeadwordRender *r = EB_HEADWORD_RENDER(cell);
    eb_headword_render_ctx ctx;
    ctx.x = cell_area->x;
    ctx.y = cell_area->y;
    ctx.window = window;
    ctx.widget = widget;
    ctx.flags = flags;
    ctx.r = EB_HEADWORD_RENDER(cell);
    htmlSAXHandler cb;
    memset(&cb, 0, sizeof(htmlSAXHandler));
    cb.startElement = &eb_headword_render_startElement;
    cb.characters = &eb_headword_render_characters;
    htmlDocPtr doc = htmlSAXParseDoc((xmlChar*)r->text, ENC_UTF8, &cb, &ctx);
    xmlFreeDoc(doc);
}

static void eb_headword_render_finalize(GObject *object)
{
    EbHeadwordRender *r = EB_HEADWORD_RENDER(object);
    if(r->text)
	g_free(r->text);
    (*G_OBJECT_CLASS(eb_headword_render_parent_class_ptr)->finalize)(object);
}

static void eb_headword_render_class_init(EbHeadwordRenderClass *klass)
{
    GObjectClass *gobject_class = G_OBJECT_CLASS(klass);
    GtkCellRendererClass *eklass = GTK_CELL_RENDERER_CLASS(klass);
    eb_headword_render_parent_class_ptr = g_type_class_peek_parent(klass);
    gobject_class->get_property = eb_headword_render_get_property;
    gobject_class->set_property = eb_headword_render_set_property;
    eklass->get_size = eb_headword_render_get_size;
    eklass->render = eb_headword_render;
    gobject_class->finalize = eb_headword_render_finalize;
    g_object_class_install_property(gobject_class, HWR_PROP_TEXT, g_param_spec_string("text", _("Text"), _("Text to render"), NULL, G_PARAM_READWRITE));
    g_object_class_install_property(gobject_class, HWR_PROP_RESULT, g_param_spec_pointer("result", _("Result"), _("Search result"), G_PARAM_READWRITE));
}

static void eb_headword_render_init(EbHeadwordRender *self)
{
    self->text = NULL;
    self->res = NULL;
    GTK_CELL_RENDERER(self)->xalign = 0.0;
    GTK_CELL_RENDERER(self)->yalign = 0.5;
    GTK_CELL_RENDERER(self)->xpad = 2;
    GTK_CELL_RENDERER(self)->ypad = 2;
}

