
#ifndef __HISTORY_H_
#define __HISTORY_H_

#include "defs.h"

void        history_prev();
void        history_next(RESULT *res);
RESULT*     history_last_result();
void        history_free_data(RESULT *res);
void        history_insert_word(const gchar *word);
void        history_save_words();
void        history_load_words();

RESULT*     result_new(BOOK_INFO *binfo, EB_Position *pos);
RESULT*     result_duplicate(RESULT *res);
void        result_copy(RESULT *to, RESULT *from);
void        result_free(gpointer data);
void        result_clear_all();
gboolean    result_compare(RESULT *res1, RESULT *res2);

struct _history
{
    GList   *list;
} history;

#endif /* __HISTORY_H_ */
