
#ifndef __HOTKEYS_H__
#define __HOTKEYS_H__

struct _hotkeys
{
    gboolean    ignore_locks;
    GList       *list;
} hotkeys;

typedef struct
{
    gchar *name;
    void (* func)();
    gboolean global;
} HOTKEY_COMMAND;

typedef struct
{
    guint32 mask, keyval;
    gboolean enabled;
} HOTKEY_EVENT;

void		hotkeys_list_init();
void            hotkeys_local_install();
void            hotkeys_global_install();
HOTKEY_EVENT*	hotkeys_find(const gchar *name);
void            hotkeys_save();
void            hotkeys_load();
void		hotkey_to_string(guint mask, guint keyval, gchar *key);

#endif /* __HOTKEYS_H__ */

