
#include "defs.h"

#include <gdk/gdkkeysyms.h>
#include <gdk/gdkx.h>

#include "pref_hotkeys.h"
#include "dictbar.h"
#include "headword.h"
#include "history.h"
#include "hotkeys.h"
#include "textview.h"

extern HOTKEY_COMMAND hotkeys_list[];

GtkLabel* pref_hotkeys_hbox_get_label(GtkHBox *hbox)
{
    GList *list = gtk_container_get_children(GTK_CONTAINER(hbox));
    return GTK_LABEL(list->data);
}

GtkEntry* pref_hotkeys_hbox_get_entry(GtkHBox *hbox)
{
    GList *list = gtk_container_get_children(GTK_CONTAINER(hbox));
    return GTK_ENTRY(list->next->data);
}

void pref_hotkeys_end(gboolean save)
{
    if(!save) return;
    hotkeys.ignore_locks = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(pref_hotkeys.locks));
    pref_hotkeys_reload();
    hotkeys_local_install();
    hotkeys_global_install();
    hotkeys_save();
    return;
}

void pref_hotkeys_reload_keys(GtkWidget *w, gpointer data)
{
    GtkHBox *hbox = GTK_HBOX(w);
    GtkLabel *label = pref_hotkeys_hbox_get_label(hbox);
    GtkEntry *entry = pref_hotkeys_hbox_get_entry(hbox);
    const gchar *name = gtk_label_get_text(label);
    const gchar *keys = gtk_entry_get_text(entry);
    HOTKEY_EVENT* evt = hotkeys_find(name);
    if(!evt) return;
    if(!strlen(keys)) return;
    guint mask, keyval;
    gtk_accelerator_parse(keys, &keyval, &mask);
    evt->mask = mask;
    evt->keyval = keyval;
    evt->enabled = (evt->keyval != 0);
}

void pref_hotkeys_reload()
{
    gint i;
    for(i = 0; hotkeys_list[i].name != NULL; i++)
    {
	HOTKEY_EVENT* evt = (HOTKEY_EVENT*)g_list_nth_data(hotkeys.list, i);
	evt->mask = evt->keyval = 0;
	evt->enabled = FALSE;
    }
    gtk_container_forall(GTK_CONTAINER(pref_hotkeys.vbox), pref_hotkeys_reload_keys, NULL);
}

static gboolean grab_hotkeys_key(GtkDialog *dlg, GdkEventKey *event, GtkHBox *hbox)
{
    gchar key[256];

    switch (event->keyval){
    case GDK_Shift_L:
    case GDK_Shift_R:
    case GDK_Control_L:
    case GDK_Control_R:
    case GDK_Meta_L:
    case GDK_Meta_R:
    case GDK_Alt_L:
    case GDK_Alt_R:
    case GDK_Caps_Lock:
    case GDK_Shift_Lock:
    case GDK_Scroll_Lock:
    case GDK_Num_Lock:
    case GDK_Kana_Lock:
        return(FALSE);
        break;
    }

    if(hotkeys.ignore_locks)
        event->state = event->state & (~GDK_LOCK_MASK) & (~GDK_MOD2_MASK);
    hotkey_to_string(event->state, event->keyval, key);

    gtk_entry_set_text(pref_hotkeys_hbox_get_entry(hbox), key);
    gtk_dialog_response(dlg, GTK_RESPONSE_OK);

    return(TRUE);
}

static void hotkeys_edit(GtkWidget *widget, GtkHBox *hbox)
{
    GtkWidget* dlg = gtk_message_dialog_new(NULL, GTK_DIALOG_MODAL, GTK_MESSAGE_INFO, GTK_BUTTONS_NONE,
                                            _("Press a key (or a key combination) to add new hotkeys,\n"
                                            "\"Clear\" to remove current hotkeys,\n"
                                            "\"Cancel\" to close this message."));
    gtk_dialog_add_buttons(GTK_DIALOG(dlg), GTK_STOCK_CLEAR, GTK_RESPONSE_NO, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, NULL);

    gtk_window_set_title(GTK_WINDOW(dlg), _("Grabbing a key."));
    g_signal_connect(G_OBJECT(dlg), "key-press-event", G_CALLBACK(grab_hotkeys_key), hbox);

    if(gtk_dialog_run(GTK_DIALOG(dlg)) == GTK_RESPONSE_NO)
        gtk_entry_set_text(pref_hotkeys_hbox_get_entry(hbox), "");
    gtk_widget_destroy(dlg);
}

GtkWidget *pref_hotkeys_start()
{
    gint i;
    GtkWidget *vbox, *hbox, *scroll, *label, *entry, *button;
    gchar keystr[64];

    vbox = gtk_vbox_new(FALSE, 0);
    scroll = gtk_scrolled_window_new(NULL, NULL);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scroll), GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);
    gtk_box_pack_start(GTK_BOX(vbox), scroll, TRUE, TRUE, 0);

    pref_hotkeys.vbox = gtk_vbox_new(TRUE, 5);
    gtk_container_set_border_width(GTK_CONTAINER(pref_hotkeys.vbox), 5);
    gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scroll), pref_hotkeys.vbox);

    for(i = 0; hotkeys_list[i].name != NULL; i++)
    {
        hbox = gtk_hbox_new(FALSE, 5);
        gtk_box_pack_start(GTK_BOX(pref_hotkeys.vbox), hbox, FALSE, FALSE, 0);
	if(hotkeys_list[i].global)
	    gtk_widget_set_tooltip_text(hbox, _("Global hotkey"));

        label = gtk_label_new(hotkeys_list[i].name);
        gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);

        button = gtk_button_new_with_label(_("Edit..."));
        gtk_box_pack_end(GTK_BOX(hbox), button, FALSE, FALSE, 0);
        g_signal_connect(G_OBJECT(button), "clicked", G_CALLBACK(hotkeys_edit), hbox);

        entry = gtk_entry_new();
        gtk_editable_set_editable(GTK_EDITABLE(entry), FALSE);
        gtk_box_pack_end(GTK_BOX(hbox), entry, FALSE, FALSE, 0);

        HOTKEY_EVENT *evt = (HOTKEY_EVENT*)g_list_nth_data(hotkeys.list, i);
        if(evt ? evt->enabled : FALSE)
        {
            hotkey_to_string(evt->mask, evt->keyval, keystr);
            gtk_entry_set_text(GTK_ENTRY(entry), keystr);
        }
    }

    pref_hotkeys.locks = gtk_check_button_new_with_label(_("Ignore locks"));
    gtk_box_pack_start(GTK_BOX(vbox), pref_hotkeys.locks, FALSE, FALSE, 0);
    gtk_widget_set_tooltip_text(pref_hotkeys.locks, _("Ignore Caps Lock and Num Lock keys"));
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(pref_hotkeys.locks), hotkeys.ignore_locks);

    return vbox;
}

