
#include "defs.h"

#include "dictbar.h"
#include "headword.h"
#include "mainwnd.h"
#include "preferences.h"
#include "pref_mainwnd.h"
#include "selection.h"
#include "textview.h"

void pref_mainwnd_end(gboolean save)
{
    if(!save) return;
    mainwnd.remember_pos = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(pref_mainwnd.wndpos));
}

GtkWidget *pref_mainwnd_start()
{
    GtkWidget *vbox;

    vbox = gtk_vbox_new(FALSE, 10);
    gtk_container_set_border_width(GTK_CONTAINER(vbox), 10);

    pref_mainwnd.wndpos = gtk_check_button_new_with_label(_("Restore window position on startup"));
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(pref_mainwnd.wndpos), mainwnd.remember_pos);
    gtk_box_pack_start(GTK_BOX(vbox), pref_mainwnd.wndpos, FALSE, FALSE, 0);

    return vbox;
}

static void pref_mainwnd_custom_font(GtkWidget *widget, gpointer data)
{
    gtk_widget_set_sensitive(pref_mainwnd.font, gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(pref_mainwnd.bfont)));
}

void pref_font_end(gboolean save)
{
    if(!save) return;
    if(mainwnd.font)
        g_free(mainwnd.font);
    mainwnd.font = NULL;

    mainwnd.custom_font = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(pref_mainwnd.bfont));
    if(mainwnd.custom_font)
        mainwnd.font = g_strdup(gtk_font_button_get_font_name(GTK_FONT_BUTTON(pref_mainwnd.font)));
    mainwnd_reset_font();
}

GtkWidget *pref_font_start()
{
    GtkWidget *vbox, *hbox;

    //mainwnd.custom_font = FALSE;
    vbox = gtk_vbox_new(FALSE, 10);
    gtk_container_set_border_width(GTK_CONTAINER(vbox), 10);

    hbox = gtk_hbox_new(FALSE, 30);
    gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);

    pref_mainwnd.bfont = gtk_check_button_new_with_label(_("Use custom application font"));
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(pref_mainwnd.bfont), mainwnd.custom_font);
    gtk_box_pack_start(GTK_BOX(hbox), pref_mainwnd.bfont, FALSE, FALSE, 0);

    if(mainwnd.custom_font)
        pref_mainwnd.font = gtk_font_button_new_with_font(mainwnd.font);
    else
        pref_mainwnd.font = gtk_font_button_new();
    pref_mainwnd_custom_font(pref_mainwnd.bfont, NULL);
    g_signal_connect(G_OBJECT(pref_mainwnd.bfont), "toggled", G_CALLBACK(pref_mainwnd_custom_font), NULL);
    gtk_box_pack_start(GTK_BOX(hbox), pref_mainwnd.font, FALSE, FALSE, 0);

    return vbox;
}

void pref_color_end(gboolean save)
{
    if(!save) return;
    gint i;
    GdkColor color;
    for(i = 0; i < COLOR_N; i++)
    {
        free(textview.colors[i]);
        gtk_color_button_get_color(GTK_COLOR_BUTTON(pref_mainwnd.colors[i]), &color);
        textview.colors[i] = gtk_color_selection_palette_to_string(&color, 1);
    }
    return;
}

GtkWidget *pref_color_start()
{
    GtkWidget *vbox, *table, *label;
    gint i;
    GdkColor color;

    vbox = gtk_vbox_new(FALSE, 10);
    gtk_container_set_border_width(GTK_CONTAINER(vbox), 5);

    table = gtk_table_new(2, 7, FALSE);
    gtk_box_pack_start(GTK_BOX(vbox), table, FALSE, FALSE, 0);

    const gchar *labels[COLOR_N];
    labels[COLOR_LINK] = _("Link");
    labels[COLOR_KEYWORD] = _("Keyword");
    labels[COLOR_TITLE] = _("Dictionary title");

    for(i = 0; i < COLOR_N; i++)
    {
        label = gtk_label_new(labels[i]);
        gtk_misc_set_alignment(GTK_MISC(label), 0, 0.5);
        gtk_table_attach(GTK_TABLE(table), label, 0, 1, i, i + 1, GTK_FILL, GTK_FILL, 5, 5);	

        gdk_color_parse(textview.colors[i], &color);
        pref_mainwnd.colors[i] = gtk_color_button_new_with_color(&color);
        gtk_table_attach(GTK_TABLE(table), pref_mainwnd.colors[i], 1, 2, i, i + 1, GTK_FILL, GTK_FILL, 5, 5);	
    }
    return vbox;
}

void pref_mainwnd_search_end(gboolean save)
{
    if(!save) return;
    dictbar.word_hist= gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(pref_mainwnd.word_hist));
    headword.maxhits = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(pref_mainwnd.hits));
}

GtkWidget *pref_mainwnd_search_start()
{
    GtkWidget *vbox, *table, *label;
    GtkObject *adj;

    vbox = gtk_vbox_new(FALSE, 0);
    gtk_container_set_border_width(GTK_CONTAINER(vbox), 5);

    table = gtk_table_new(2, 2, FALSE);
    gtk_box_pack_start (GTK_BOX(vbox), table, FALSE, FALSE, 0);

    label = gtk_label_new(_("Maximum words in history"));
    gtk_misc_set_alignment(GTK_MISC(label), 0, 0.5);
    gtk_table_attach(GTK_TABLE(table), label, 0, 1, 0, 1, GTK_FILL, GTK_FILL, 5, 5);

    adj = gtk_adjustment_new(dictbar.word_hist, 0, 50, 1, 10, (gfloat)0.0);
    pref_mainwnd.word_hist = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 1.0, 0);
    gtk_table_attach(GTK_TABLE(table), pref_mainwnd.word_hist, 1, 2, 0, 1, GTK_FILL, GTK_FILL, 5, 5);	
    gtk_widget_set_tooltip_text(pref_mainwnd.word_hist, _("Maximum number of words to remember in word history"));

    label = gtk_label_new(_("Maximum hits to search"));
    gtk_misc_set_alignment(GTK_MISC(label), 0, 0.5);
    gtk_table_attach(GTK_TABLE(table), label, 0, 1, 1, 2, GTK_FILL, GTK_FILL, 5, 5);
    
    adj = gtk_adjustment_new(headword.maxhits, 1, 1000, 1, 10, 0.0);
    pref_mainwnd.hits = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 1.0, 0);
    gtk_table_attach(GTK_TABLE(table), pref_mainwnd.hits, 1, 2, 1, 2, GTK_FILL, GTK_FILL, 5, 5);	
    gtk_widget_set_tooltip_text(pref_mainwnd.hits, _("Maximum number of hits to be displayed at once.\nYou can go forward and backward using buttons. Valid only if automatic calculation is disabled"));

    return vbox;
}
