
#include "defs.h"
#include "mainwnd.h"
#include "selection.h"
#include "popupwnd.h"
#include "pref_popupwnd.h"

void pref_popupwnd_end(gboolean save)
{
    if(!save) return;
    popupwnd.w = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(pref_popupwnd.width));
    popupwnd.h = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(pref_popupwnd.height));
    popupwnd.remember_pos = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(pref_popupwnd.remember_pos));
}

GtkWidget *pref_popupwnd_start()
{
    GtkWidget *vbox, *hbox, *label;
    GtkObject *adj;

    vbox = gtk_vbox_new(FALSE, 10);
    gtk_container_set_border_width(GTK_CONTAINER(vbox), 10);

    hbox = gtk_hbox_new(FALSE, 20);
    gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);

    label = gtk_label_new(_("Popup window size"));
    gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);

    adj = gtk_adjustment_new(popupwnd.w, 1, 1024, 10, 10, (gfloat)0.0);
    pref_popupwnd.width = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 1.0, 0);
    gtk_widget_set_tooltip_text(pref_popupwnd.width, _("Width"));
    gtk_box_pack_start(GTK_BOX(hbox), pref_popupwnd.width, FALSE, FALSE, 0);

    label = gtk_label_new("x");
    gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);

    adj = gtk_adjustment_new(popupwnd.h, 1, 1024, 10, 10, (gfloat)0.0);
    pref_popupwnd.height = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 1.0, 0);
    gtk_widget_set_tooltip_text(pref_popupwnd.height, _("Height"));
    gtk_box_pack_start(GTK_BOX(hbox), pref_popupwnd.height, FALSE, FALSE, 0);

    pref_popupwnd.remember_pos = gtk_check_button_new_with_label(_("Remember popup window position"));
    gtk_box_pack_start(GTK_BOX(vbox), pref_popupwnd.remember_pos, FALSE, FALSE, 0);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(pref_popupwnd.remember_pos), popupwnd.remember_pos);

    return vbox;
}

void pref_popupwnd_search_end(gboolean save)
{
    if(!save) return;
    selection.maxchar = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(pref_popupwnd.maxchar));
    popupwnd.maxhits = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(pref_popupwnd.hits));
    popupwnd.search_method = gtk_combo_box_get_active(GTK_COMBO_BOX(pref_popupwnd.method));
}

GtkWidget *pref_popupwnd_search_start()
{
    GtkWidget *vbox, *table, *label;
    GtkObject *adj;

    vbox = gtk_vbox_new(FALSE, 10);
    gtk_container_set_border_width(GTK_CONTAINER(vbox), 5);

    table = gtk_table_new(4, 2, FALSE);
    gtk_box_pack_start(GTK_BOX(vbox), table, FALSE, FALSE, 0);

    label = gtk_label_new(_("Maximum chars for automatic lookup"));
    gtk_misc_set_alignment(GTK_MISC(label), 0, 0.5);
    gtk_table_attach(GTK_TABLE(table), label, 0, 1, 0, 1, GTK_FILL, GTK_FILL, 5, 5);

    adj = gtk_adjustment_new(selection.maxchar, 1, 1000, 1, 10, (gfloat)0.0);
    pref_popupwnd.maxchar = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 1.0, 0);
    gtk_table_attach(GTK_TABLE(table), pref_popupwnd.maxchar, 1, 2, 0, 1, GTK_FILL, GTK_FILL, 5, 5);
    gtk_widget_set_tooltip_text(pref_popupwnd.maxchar, _("Do not lookup words longer than this number of characters."));

    label = gtk_label_new(_("Maximum hits to search in popup"));
    gtk_misc_set_alignment(GTK_MISC(label), 0, 0.5);
    gtk_table_attach(GTK_TABLE(table), label, 0, 1, 1, 2, GTK_FILL, GTK_FILL, 5, 5);

    adj = gtk_adjustment_new(popupwnd.maxhits, 1, 50, 1, 10, 0.0);
    pref_popupwnd.hits = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 1.0, 0);
    gtk_table_attach(GTK_TABLE(table), pref_popupwnd.hits, 1, 2, 1, 2, GTK_FILL, GTK_FILL, 5, 5);
    gtk_widget_set_tooltip_text(pref_popupwnd.hits, _("Maximum number of results to search for in popup window."));

    label = gtk_label_new(_("Popup search method"));
    gtk_misc_set_alignment(GTK_MISC(label), 0, 0.5);
    gtk_table_attach(GTK_TABLE(table), label, 0, 1, 2, 3, GTK_FILL, GTK_FILL, 5, 5);

    pref_popupwnd.method = mainwnd_search_method_combo();
    gtk_combo_box_set_active(GTK_COMBO_BOX(pref_popupwnd.method), popupwnd.search_method);
    gtk_table_attach(GTK_TABLE(table), pref_popupwnd.method, 1, 2, 2, 3, GTK_FILL, GTK_FILL, 5, 5);
    gtk_widget_set_tooltip_text(pref_popupwnd.method, _("Search method to use in popup."));

    return vbox;
}

