
#include "defs.h"

#include "audio.h"
#include "dicts.h"
#include "ebook.h"
#include "headword.h"
#include "jcode.h"
#include "history.h"
#include "render.h"
#include "textview.h"
#include "toolbar.h"
#include "video.h"

void render_parse_link(gchar *str, RESULT *lnk)
{
    gint i;
    gchar **ca = g_strsplit_set(str, "= >", 0);
    if(!lnk) lnk = render.link;
    for(i = 0; i < g_strv_length(ca); i += 2)
    {
	if(!g_strcmp0(ca[i], "page"))
	    lnk->pos.page = g_ascii_strtoll(ca[i+1], NULL, 16);
	if(!g_strcmp0(ca[i], "offset"))
	    lnk->pos.offset = g_ascii_strtoll(ca[i+1], NULL, 16);
	if(!g_strcmp0(ca[i], "size"))
	    lnk->size = g_ascii_strtoll(ca[i+1], NULL, 10);
	if(!g_strcmp0(ca[i], "filename"))
	    lnk->filename = g_strdup(ca[i+1]);
    }
    g_strfreev(ca);
}

void render_gaiji(gchar *code)
{
    GdkPixbuf *pixbuf;
    GtkTextIter iter;
    gint w, h;

    if(!(pixbuf = ebook_read_gaiji(render.binfo, code, &w, &h)))
        return;
    gtk_text_buffer_get_end_iter(render.buf, &iter);
    gtk_text_buffer_insert_pixbuf(render.buf, &iter, pixbuf);
}

void render_startElement(void *ctx, const xmlChar *name, const xmlChar **atts)
{
    GtkTextIter iter;
    gint len = atts ? g_strv_length((gchar**)atts) : 0;
    gtk_text_buffer_get_end_iter(render.buf, &iter);
    if(!g_strcmp0((char*)name, "gaiji") && (len > 1))
    {
        render_gaiji((gchar *)atts[1]);
        return;
    }
    if(!g_strcmp0((char*)name, "indent") && (len > 1))
    {
        gint indent = g_ascii_strtoll((gchar*)atts[1], NULL, 10), i;
        for(i = 0; i < indent; i++)
            gtk_text_buffer_insert(render.buf, &iter, " ", -1);
        return;
    }
    if((!g_strcmp0((char*)name, "jpeg") || !strcmp((char*)name, "bmp")) && (len > 3))
    {
        GdkPixbuf *pixbuf;
	EB_Position pos;
        pos.page = g_ascii_strtoll((gchar*)atts[1], NULL, 16);
        pos.offset = g_ascii_strtoll((gchar*)atts[3], NULL, 16);
        pixbuf = ebook_load_image(render.binfo, &pos);
        if(pixbuf)
	{
            gtk_text_buffer_insert_pixbuf(render.buf, &iter, pixbuf);
	    gtk_text_buffer_insert(render.buf, &iter, "\r\0", -1);
	}
        return;
    }
    else if(!g_strcmp0((char*)name, "mpeg"))
    {
	render.link = result_new(render.binfo, NULL);
	render.link->filename = g_strdup((gchar*)atts[1]);
    }
    gtk_text_buffer_create_mark(render.buf, "link", &iter, TRUE);
#if 0 //ndef ENABLE_GSTREAMER
    if(!g_strcmp0((char*)name, "wave"))
    {
	gtk_text_buffer_insert(render.buf, &iter, _("\n[Audio]"), -1);
    }
    if(!g_strcmp0((char*)name, "mpeg"))
    {
	gtk_text_buffer_insert(render.buf, &iter, _("\n[Video]"), -1);
    }
#endif
}

gboolean render_get_last_link(GtkTextIter *iter1, GtkTextIter *iter2)
{
    GtkTextMark *mark = gtk_text_buffer_get_mark(render.buf, "link");
    if(mark)
    {
        gtk_text_buffer_get_iter_at_mark(render.buf, iter1, mark);
        gtk_text_buffer_delete_mark(render.buf, mark);
        gtk_text_buffer_get_end_iter(render.buf, iter2);
        return TRUE;
    }
    return FALSE;
}

void render_set_link(GtkTextIter *iter1, GtkTextIter *iter2, gchar *type, gchar *color)
{
    GtkTextTag *tag = gtk_text_buffer_create_tag(render.buf, NULL, "foreground", color, NULL);
    gtk_text_buffer_apply_tag(render.buf, tag, iter1, iter2);
    if(render.link ? !render.link->filename : TRUE)
	render.link = result_new(render.binfo, NULL);
    g_object_set_data_full(G_OBJECT(tag), type, render.link, result_free);
}

void render_endElement(void *ctx, const xmlChar *name)
{
    gchar *color = NULL, type[16];
    GtkTextIter iter1, iter2;
    gtk_text_buffer_get_end_iter(render.buf, &iter2);
    if(!g_strcmp0((char*)name, "keyword"))
        color = textview.colors[COLOR_KEYWORD];
    else if(!g_strcmp0((char*)name, "reference") || !strcmp((char*)name, "candidate"))
    {
        color = textview.colors[COLOR_LINK];
        sprintf(type, "%s", "link");
    }
    else if(!g_strcmp0((char*)name, "wave"))
    {
	EbAudio *audio = g_object_new(EB_TYPE_AUDIO, NULL);
        eb_audio_render(audio);
    }
    else if(!g_strcmp0((char*)name, "mpeg"))
    {
	EbVideo *video = g_object_new(EB_TYPE_VIDEO, NULL);
        eb_video_render(video);
    }
    else
        return;
    if(render_get_last_link(&iter1, &iter2))
        render_set_link(&iter1, &iter2, type, color);
}

void render_characters(void *ctx, const xmlChar *ch, int len)
{
    gchar *s = g_strstr_len((gchar*)ch, len, ">");
    GtkTextIter iter;
    if(s)
    {
	GtkTextIter end;
        render_parse_link((gchar*)ch, NULL);
	gtk_text_buffer_get_end_iter(render.buf, &end);
	gtk_text_buffer_insert(render.buf, &end, &(s[1]), -1);
        return;
    }
    gtk_text_buffer_get_end_iter(render.buf, &iter);
    gtk_text_buffer_insert(render.buf, &iter, (gchar*)ch, len);
}

void render_title(gchar *title)
{
    GtkTextIter iter;
    GtkTextTag *tag;
    gtk_text_buffer_get_end_iter(render.buf, &iter);
    tag = gtk_text_buffer_create_tag(render.buf, NULL, "foreground", textview.colors[COLOR_TITLE], "justification", GTK_JUSTIFY_CENTER, "scale", 1.2, NULL);
    gtk_text_buffer_insert_with_tags(render.buf, &iter, "---", -1, tag, NULL);
    gtk_text_buffer_insert_with_tags(render.buf, &iter, title, -1, tag, NULL);
    gtk_text_buffer_insert_with_tags(render.buf, &iter, "---", -1, tag, NULL);
    gtk_text_buffer_insert(render.buf, &iter, "\n", -1);
}

void render_content(BOOK_INFO *binfo, EbTextView *view, gchar *text)
{
    gchar *utf_text = iconv_convert(ENC_EUC_JP, ENC_UTF8, text);
    htmlSAXHandler cb;
    memset(&cb, 0, sizeof(htmlSAXHandler));
    cb.startElement = &render_startElement;
    cb.endElement = &render_endElement;
    cb.characters = &render_characters;
    render.binfo = binfo;
    render.view = view;
    render.buf = gtk_text_view_get_buffer(GTK_TEXT_VIEW(view));
    render_title(binfo->title);
    htmlDocPtr doc = htmlSAXParseDoc((xmlChar*)utf_text, ENC_UTF8, &cb, NULL);
    xmlFreeDoc(doc);
    g_free(utf_text);
    render.buf = NULL;
    render.binfo = NULL;
    render.link = NULL;
    render.view = NULL;
}

