
#include "defs.h"
#include "ebook.h"
#include "headword.h"
#include "history.h"
#include "jcode.h"
#include "mainwnd.h"
#include "popupwnd.h"
#include "selection.h"

#define SELECTION_TIMEOUT 300

static gchar* selection_copy(gboolean force_copy)
{
    GtkClipboard* clipboard = gtk_clipboard_get(GDK_SELECTION_PRIMARY);
    gchar *str = gtk_clipboard_wait_for_text(clipboard);
    static gchar *sel = NULL, *sel_prev = NULL;
    if(!str || (selection.lookup_suspended && !force_copy))
    {
        if(sel_prev)
            g_free(sel_prev);
        sel_prev = NULL;
        return NULL;
    }
    g_strstrip(str);
    str = g_strdelimit(str, G_STR_DELIMITERS, '\n');
    gint len = strlen(str);
    if((len > selection.maxchar) || g_strrstr(str, "\n"))
    {
        g_free(sel_prev);
        sel_prev = NULL;
        g_free(str);
        return NULL;
    }
    if(force_copy)
	sel = str;
    else
    {
	if(!sel)
	{
	    sel = str;
	    return NULL;
	}
	if(strncmp(str, sel, selection.maxchar))
	{
	    g_free(sel);
	    sel = str;
	    return NULL;
	}
	g_free(str);
	if((sel_prev) ? !strncmp(sel_prev, sel, selection.maxchar) : FALSE)
	    return NULL;
    }
    sel_prev = sel;
    sel = NULL;
    return sel_prev;
}

gint selection_search_in_popupwnd_cb(gpointer data)
{
    gchar *sel = selection_copy(FALSE);
    if(sel)
	popupwnd_search(sel);
    return 1;
}

void selection_search_in_mainwnd()
{
    gchar *sel = selection_copy(TRUE);
    if(sel)
	mainwnd_search(sel);
}

void selection_search_in_popupwnd()
{
    gchar *sel = selection_copy(TRUE);
    if(sel)
	popupwnd_search(sel);
}

void selection_lookup_start()
{
    selection.lookup_started = TRUE;
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(popupwnd.scan), TRUE);
    selection_lookup_resume();
}

void selection_lookup_stop()
{
    selection.lookup_started = FALSE;
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(popupwnd.scan), FALSE);
    selection_lookup_suspend();
}

void selection_lookup_suspend()
{
    if(selection.timeout_id != 0)
        g_source_remove(selection.timeout_id);
    selection.timeout_id = 0;
    popupwnd_close(NULL, NULL);
    selection.lookup_suspended = TRUE;
}

void selection_lookup_resume()
{
    if(selection.lookup_started)
    {
        if(selection.timeout_id != 0)
            g_source_remove(selection.timeout_id);
        selection.timeout_id = g_timeout_add(SELECTION_TIMEOUT, selection_search_in_popupwnd_cb, NULL);
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(popupwnd.scan), TRUE);
    }
    selection.lookup_suspended = FALSE;
}

void selection_toggled(GtkToggleButton *togglebutton, gpointer data)
{
    if(gtk_toggle_button_get_active(togglebutton))
        selection_lookup_start();
    else
        selection_lookup_stop();
}

