
#ifndef __EB_TEXTVIEW_H__
#define __EB_TEXTVIEW_H__

#include "defs.h"
#include "video.h"

G_BEGIN_DECLS

#define EB_TYPE_TEXTVIEW (eb_textview_get_type ())
#define EB_TEXTVIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EB_TYPE_TEXTVIEW, EbTextView))
#define EB_TEXTVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EB_TYPE_TEXTVIEW, EbTextViewClass))
#define EB_IS_TEXTVIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EB_TYPE_TEXTVIEW))
#define EB_IS_TEXTVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EB_TYPE_TEXTVIEW))
#define EB_TEXTVIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EB_TYPE_TEXTVIEW, EbTextViewClass))

typedef struct _EbTextView EbTextView;
typedef struct _EbTextViewClass EbTextViewClass;

struct _EbTextView {
    GtkTextView	    parent_instance;
    GtkTextTag	    *tag;
};

struct _EbTextViewClass {
    GtkTextViewClass    parent_class;
    void		(*history_next)(RESULT *res);
};

void	    eb_textview_open(EbTextView *self, RESULT *res, gboolean clear, gint mark);
void        eb_textview_push_message(EbTextView *self, gchar *msg);
void        eb_textview_set_pixels(EbTextView *self, gint n);
void        eb_textview_clear_textbuf(EbTextView *self);
void        eb_textview_insert_message(EbTextView *self, gchar *msg, gboolean clear);
void        eb_textview_underline_lnk(GtkWidget *widget, GdkEventMotion *event, GtkTextTag **tag_lnk);
gint        eb_textview_button_press(GtkWidget *widget, GdkEventButton *event, gpointer data);
void	    eb_textview_populate_popup(GtkTextView *tview, GtkMenu *menu, gpointer user_data);

GType	    eb_textview_get_type (void);

G_END_DECLS

struct _textview
{
    gchar           *colors[COLOR_N];
} textview;

#endif /* __EB_TEXTVIEW_H__ */

