
#ifndef __EB_VIDEO_H__
#define __EB_VIDEO_H__

#include "defs.h"

G_BEGIN_DECLS

#define EB_TYPE_VIDEO (eb_video_get_type ())
#define EB_VIDEO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EB_TYPE_VIDEO, EbVideo))
#define EB_VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EB_TYPE_VIDEO, EbVideoClass))
#define EB_IS_VIDEO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EB_TYPE_VIDEO))
#define EB_IS_VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EB_TYPE_VIDEO))
#define EB_VIDEO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EB_TYPE_VIDEO, EbVideoClass))

typedef struct _EbVideo EbVideo;
typedef struct _EbVideoClass EbVideoClass;

struct _EbVideo {
    GtkFrame	    parent_instance;

#ifdef ENABLE_GSTREAMER
    GtkWidget *output, *btn, *time;
    GstElement *pipeline, *sink;
    gboolean	video_resized;
    GMainLoop *loop;
#endif
};

struct _EbVideoClass {
    GtkFrameClass   parent_class;
};

void		eb_video_output_finalize(EbVideo *self);
void		eb_video_render(EbVideo *self);

GType		eb_video_get_type (void);

G_END_DECLS

#endif

