/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.aws.ui.view;

import jp.co.intellilink.aws.ui.Activator;
import jp.co.intellilink.aws.ui.model.GroupModel;
import jp.co.intellilink.aws.ui.model.InstanceModel;
import jp.co.intellilink.aws.ui.model.ReservationModel;
import jp.co.intellilink.aws.ui.view.Messages;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class InstanceLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            if (element instanceof ReservationModel) {
                return Activator.imageDescriptorFromPlugin((String)"jp.co.intellilink.aws.ui", (String)"icons/package.png").createImage();
            }
            if (element instanceof GroupModel) {
                return Activator.imageDescriptorFromPlugin((String)"jp.co.intellilink.aws.ui", (String)"icons/group.png").createImage();
            }
            if (element instanceof InstanceModel) {
                return Activator.imageDescriptorFromPlugin((String)"jp.co.intellilink.aws.ui", (String)"icons/monitor.png").createImage();
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof ReservationModel) {
            if (columnIndex == 0) {
                return ((ReservationModel)element).getReservationId();
            }
        } else if (element instanceof GroupModel) {
            if (columnIndex == 0) {
                return ((GroupModel)element).getGroupName();
            }
        } else if (element instanceof InstanceModel) {
            InstanceModel model = (InstanceModel)element;
            switch (columnIndex) {
                case 0: {
                    return model.getInstanceId();
                }
                case 1: {
                    return model.getImageId();
                }
                case 2: {
                    return model.getDnsName();
                }
                case 3: {
                    return model.getPrivateDnsName();
                }
                case 4: {
                    return this.getStateString(model.getInstanceState());
                }
                case 5: {
                    return model.getKey();
                }
                case 6: {
                    return model.getType();
                }
                case 7: {
                    return model.getLaunchTime();
                }
                case 8: {
                    return model.getReason();
                }
            }
        }
        return null;
    }

    private String getStateString(int instanceState) {
        switch (instanceState) {
            case 0: {
                return Messages.getString("InstanceLabelProvider.3");
            }
            case 16: {
                return Messages.getString("InstanceLabelProvider.4");
            }
            case 32: {
                return Messages.getString("InstanceLabelProvider.5");
            }
            case 48: {
                return Messages.getString("InstanceLabelProvider.6");
            }
        }
        return null;
    }
}

