/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.aws.ui.view;

import java.util.List;
import jp.co.intellilink.aws.api.ElasticComputingCloudInterface;
import jp.co.intellilink.aws.api.transport.EC2Address;
import jp.co.intellilink.aws.api.transport.EC2DescribeAddressRequest;
import jp.co.intellilink.aws.core.CoreException;
import jp.co.intellilink.aws.core.EC2ServiceProvider;
import jp.co.intellilink.aws.ui.Activator;
import jp.co.intellilink.aws.ui.view.ActionCallbackHandler;
import jp.co.intellilink.aws.ui.view.CallbackAction;
import jp.co.intellilink.aws.ui.view.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class AllocateAddressAction
extends CallbackAction {
    public AllocateAddressAction(ActionCallbackHandler handler) {
        super(handler, Messages.getString("AllocateAddressAction.0"));
        this.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"jp.co.intellilink.aws.ui", (String)"icons/allocate_address.png"));
    }

    public void run() {
        Job job = new Job(Messages.getString("AllocateAddressAction.2")){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(Messages.getString("AllocateAddressAction.3"), 10);
                monitor.setTaskName(Messages.getString("AllocateAddressAction.4"));
                EC2ServiceProvider provider = Activator.getDefault().getProvider();
                monitor.worked(2);
                try {
                    ElasticComputingCloudInterface ec2 = provider.getEC2();
                    monitor.setTaskName(Messages.getString("AllocateAddressAction.5"));
                    EC2Address address = ec2.allocateAddress();
                    if (address.getAddress() == null || address.getAddress().equals("")) {
                        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.getString("AllocateAddressAction.7"), (String)Messages.getString("AllocateAddressAction.8"));
                        return Status.CANCEL_STATUS;
                    }
                    monitor.worked(5);
                    monitor.setTaskName(Messages.getString("AllocateAddressAction.9"));
                    EC2DescribeAddressRequest request = new EC2DescribeAddressRequest();
                    final List responseType = ec2.describeAddress(request);
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            AllocateAddressAction.this.getHandler().onDescribeAddressExecuted(responseType);
                        }
                    });
                    monitor.done();
                    return Status.OK_STATUS;
                }
                catch (CoreException e) {
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.getString("AllocateAddressAction.10"), (String)e.getMessage());
                    return Status.CANCEL_STATUS;
                }
            }
        };
        job.schedule();
    }
}

