/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.aws.ui.view;

import java.util.List;
import jp.co.intellilink.aws.api.ElasticComputingCloudInterface;
import jp.co.intellilink.aws.core.CoreException;
import jp.co.intellilink.aws.core.EC2ServiceProvider;
import jp.co.intellilink.aws.ui.Activator;
import jp.co.intellilink.aws.ui.view.ActionCallbackHandler;
import jp.co.intellilink.aws.ui.view.CallbackAction;
import jp.co.intellilink.aws.ui.view.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class DescribeAddressAction
extends CallbackAction {
    public DescribeAddressAction(ActionCallbackHandler handler) {
        super(handler, Messages.getString("DescribeAddressAction.0"));
        this.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"jp.co.intellilink.aws.ui", (String)"icons/refresh.png"));
    }

    public void run() {
        super.run();
        Job job = new Job(Messages.getString("DescribeAddressAction.2")){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(Messages.getString("DescribeAddressAction.3"), 10);
                monitor.setTaskName(Messages.getString("DescribeAddressAction.1"));
                EC2ServiceProvider provider = Activator.getDefault().getProvider();
                monitor.worked(2);
                try {
                    monitor.setTaskName(Messages.getString("DescribeAddressAction.5"));
                    ElasticComputingCloudInterface ec2 = provider.getEC2();
                    final List address = ec2.describeAddress(null);
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            DescribeAddressAction.this.getHandler().onDescribeAddressExecuted(address);
                        }
                    });
                    monitor.done();
                    return Status.OK_STATUS;
                }
                catch (CoreException e) {
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.getString("DescribeAddressAction.6"), (String)e.getMessage());
                    return Status.CANCEL_STATUS;
                }
            }
        };
        job.schedule();
    }
}

