/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.aws.ui.view;

import java.util.List;
import jp.co.intellilink.aws.api.ElasticComputingCloudInterface;
import jp.co.intellilink.aws.api.transport.EC2DescribeInstanceRequest;
import jp.co.intellilink.aws.core.CoreException;
import jp.co.intellilink.aws.core.EC2ServiceProvider;
import jp.co.intellilink.aws.ui.Activator;
import jp.co.intellilink.aws.ui.view.ActionCallbackHandler;
import jp.co.intellilink.aws.ui.view.CallbackAction;
import jp.co.intellilink.aws.ui.view.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class DescribeInstancesAction
extends CallbackAction {
    public DescribeInstancesAction(ActionCallbackHandler handler) {
        super(handler, Messages.getString("DescribeInstancesAction.0"));
        this.setActionDefinitionId(((Object)((Object)this)).getClass().getName());
        this.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"jp.co.intellilink.aws.ui", (String)Messages.getString("DescribeInstancesAction.1")));
    }

    public void run() {
        super.run();
        Job job = new Job(Messages.getString("DescribeInstancesAction.2")){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(Messages.getString("DescribeInstancesAction.3"), 10);
                monitor.setTaskName(Messages.getString("DescribeInstancesAction.4"));
                EC2ServiceProvider provider = Activator.getDefault().getProvider();
                monitor.worked(1);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                try {
                    monitor.setTaskName(Messages.getString("DescribeInstancesAction.5"));
                    ElasticComputingCloudInterface ec2 = provider.getEC2();
                    EC2DescribeInstanceRequest request = new EC2DescribeInstanceRequest();
                    final List instance = ec2.describeInstance(request);
                    monitor.worked(8);
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    monitor.setTaskName(Messages.getString("DescribeInstancesAction.6"));
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            DescribeInstancesAction.this.getHandler().onDescribeInstancesExecuted(instance);
                        }
                    });
                    monitor.done();
                    return Status.OK_STATUS;
                }
                catch (CoreException e) {
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.getString("DescribeInstancesAction.7"), (String)e.getMessage());
                    return Status.CANCEL_STATUS;
                }
            }
        };
        job.schedule();
    }
}

