/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.aws.ui.view;

import java.util.List;
import jp.co.intellilink.aws.api.ElasticComputingCloudInterface;
import jp.co.intellilink.aws.api.transport.EC2SecurityGroup;
import jp.co.intellilink.aws.core.CoreException;
import jp.co.intellilink.aws.ui.Activator;
import jp.co.intellilink.aws.ui.view.ActionCallbackHandler;
import jp.co.intellilink.aws.ui.view.AddIpPermissionJob;
import jp.co.intellilink.aws.ui.view.CallbackAction;
import jp.co.intellilink.aws.ui.wizard.AddIpPermissionWizard;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.PlatformUI;

public class AddIpPermissionAction
extends CallbackAction {
    public AddIpPermissionAction(ActionCallbackHandler handler) {
        super(handler, "Add IP Permission");
    }

    public void run() {
        super.run();
        PreferenceStore store = new PreferenceStore();
        List<EC2SecurityGroup> groups = this.getSecurityGroups();
        if (groups == null || groups.size() == 0) {
            return;
        }
        AddIpPermissionWizard wizard = new AddIpPermissionWizard(store, groups);
        WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            System.out.println("Dialog OK.");
            AddIpPermissionJob job = new AddIpPermissionJob("Add Ip Permisiion.", store);
            job.schedule();
        }
    }

    private List<EC2SecurityGroup> getSecurityGroups() {
        ElasticComputingCloudInterface client = null;
        try {
            client = Activator.getDefault().getProvider().getEC2();
            List securityGroups = client.describeSecurityGroups(null);
            return securityGroups;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }
}

