/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.aws.ui.view;

import java.util.List;
import jp.co.intellilink.aws.api.ElasticComputingCloudInterface;
import jp.co.intellilink.aws.api.transport.EC2CreateSecurityGroupRequest;
import jp.co.intellilink.aws.core.CoreException;
import jp.co.intellilink.aws.core.EC2ServiceProvider;
import jp.co.intellilink.aws.ui.Activator;
import jp.co.intellilink.aws.ui.view.ActionCallbackHandler;
import jp.co.intellilink.aws.ui.view.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class CreateSecurityGroupJob
extends Job {
    private IPreferenceStore store;
    private ActionCallbackHandler handler;

    public CreateSecurityGroupJob(String name, IPreferenceStore store, ActionCallbackHandler handler) {
        super(name);
        this.store = store;
        this.handler = handler;
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask("CreateSecurityGroup", 0);
        monitor.setTaskName("Resolve EC2 Client...");
        EC2ServiceProvider provider = Activator.getDefault().getProvider();
        monitor.worked(10);
        try {
            monitor.setTaskName("Request Generating...");
            ElasticComputingCloudInterface client = provider.getEC2();
            EC2CreateSecurityGroupRequest request = new EC2CreateSecurityGroupRequest();
            request.setName(this.store.getString("groupName"));
            request.setDescription(this.store.getString("description"));
            monitor.worked(30);
            monitor.setTaskName("Sending Request...");
            client.createSecurityGroup(request);
            final List groups = client.describeSecurityGroups(null);
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    CreateSecurityGroupJob.this.handler.onDescribeSecurityGroupsExecuted(groups);
                }
            });
            monitor.done();
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.getString("Failed to connnect."), (String)e.getMessage());
            return Status.CANCEL_STATUS;
        }
    }
}

