/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.aws.ui.wizard;

import java.util.ArrayList;
import java.util.List;
import jp.co.intellilink.aws.api.transport.EC2SecurityGroup;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class AddIpPermissionWizardPage
extends WizardPage {
    private static final String[][] PROTOCOLS = new String[][]{{"TCP", "tcp"}, {"UDP", "udp"}, {"ICMP", "icmp"}};
    private final IPreferenceStore store;
    private List<FieldEditor> editors = new ArrayList<FieldEditor>();
    private ComboFieldEditor groupComboEditor;
    private String[][] groups;
    private ComboFieldEditor protocolComboEditor;
    private StringFieldEditor portEditor;
    private StringFieldEditor sourceCidrIpEditor;

    protected AddIpPermissionWizardPage(IPreferenceStore store) {
        super("IP Permission Setting");
        this.setTitle("Add IP Permission");
        this.setDescription("Add New IP Permission.");
        this.store = store;
    }

    public void createControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        this.groupComboEditor = new ComboFieldEditor("securityGroup", "Security Group", this.groups, composite);
        this.groupComboEditor.setPreferenceStore(this.store);
        this.editors.add((FieldEditor)this.groupComboEditor);
        this.protocolComboEditor = new ComboFieldEditor("protocol", "Protocol", PROTOCOLS, composite);
        this.protocolComboEditor.setPreferenceStore(this.store);
        this.editors.add((FieldEditor)this.protocolComboEditor);
        this.portEditor = new StringFieldEditor("portRange", "Port or Port Range", composite);
        this.portEditor.setPreferenceStore(this.store);
        this.editors.add((FieldEditor)this.portEditor);
        this.sourceCidrIpEditor = new StringFieldEditor("cidrIp", "CIDR IP address range", composite);
        this.sourceCidrIpEditor.setPreferenceStore(this.store);
        this.editors.add((FieldEditor)this.sourceCidrIpEditor);
        this.setControl((Control)parent);
    }

    public void onFinish() {
        for (FieldEditor editor : this.editors) {
            editor.store();
        }
    }

    public void setGroups(List<EC2SecurityGroup> groups) {
        this.groups = new String[groups.size()][2];
        int i = 0;
        for (EC2SecurityGroup group : groups) {
            this.groups[i][0] = group.getName();
            this.groups[i][1] = group.getName();
            ++i;
        }
    }
}

