/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.aws.ui.wizard;

import java.util.Iterator;
import java.util.List;
import jp.co.intellilink.aws.ui.wizard.Messages;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class InstancePlacementPage
extends WizardPage {
    private final IPreferenceStore store;
    private String[][] groups;
    private String[][] zones;
    private Composite zonePanel;
    private ComboFieldEditor groupEditor;
    private StringFieldEditor additionalEditor;
    private ComboFieldEditor zoneEditor;

    protected InstancePlacementPage(IPreferenceStore store) {
        super("placement");
        this.store = store;
        this.setTitle(Messages.getString("InstancePlacementPage.1"));
        this.setDescription(Messages.getString("InstancePlacementPage.2"));
    }

    public void setGroups(List<String> groups) {
        this.groups = new String[groups.size()][2];
        int i = 0;
        Iterator<String> iterator = groups.iterator();
        while (iterator.hasNext()) {
            String key;
            this.groups[i][0] = key = iterator.next();
            this.groups[i][1] = key;
            ++i;
        }
    }

    public void setAvailabilityZones(List<String> availabilityZones) {
        this.zones = new String[availabilityZones.size()][2];
        int i = 0;
        Iterator<String> iterator = availabilityZones.iterator();
        while (iterator.hasNext()) {
            String key;
            this.zones[i][0] = key = iterator.next();
            this.zones[i][1] = key;
            ++i;
        }
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        this.zonePanel = new Composite(container, 0);
        this.zoneEditor = new ComboFieldEditor("availabilityZone", Messages.getString("InstancePlacementPage.4"), this.zones, this.zonePanel);
        this.zoneEditor.setPreferenceStore(this.store);
        this.zoneEditor.load();
        Composite groupPanel = new Composite(container, 0);
        this.groupEditor = new ComboFieldEditor("securityGroup", Messages.getString("InstancePlacementPage.6"), this.groups, groupPanel);
        this.groupEditor.setPreferenceStore(this.store);
        this.groupEditor.load();
        Composite additinalPanel = new Composite(container, 0);
        this.additionalEditor = new StringFieldEditor("additionalInfo", Messages.getString("InstancePlacementPage.8"), additinalPanel);
        this.additionalEditor.setPreferenceStore(this.store);
        this.additionalEditor.load();
        additinalPanel.setLayoutData((Object)new GridData(768));
        this.setControl((Control)container);
    }

    public void onFinished() {
        this.zoneEditor.store();
        this.groupEditor.store();
        this.additionalEditor.store();
    }
}

