/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.aws.ui.action;

import java.util.ArrayList;
import java.util.List;
import jp.co.intellilink.aws.api.ElasticComputingCloudInterface;
import jp.co.intellilink.aws.api.transport.EC2AssociateRequest;
import jp.co.intellilink.aws.api.transport.EC2DescribeAddressRequest;
import jp.co.intellilink.aws.api.transport.EC2DescribeInstanceRequest;
import jp.co.intellilink.aws.api.transport.EC2Instance;
import jp.co.intellilink.aws.core.CoreException;
import jp.co.intellilink.aws.core.EC2ServiceProvider;
import jp.co.intellilink.aws.ui.Activator;
import jp.co.intellilink.aws.ui.action.CallbackAction;
import jp.co.intellilink.aws.ui.model.ElasticIPModel;
import jp.co.intellilink.aws.ui.view.ActionCallbackHandler;
import jp.co.intellilink.aws.ui.view.Messages;
import jp.co.intellilink.aws.ui.wizard.AttachIpWizard;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class AttachIpAction
extends CallbackAction
implements ISelectionChangedListener {
    private ElasticIPModel model;

    public AttachIpAction(ActionCallbackHandler handler) {
        super(handler, Messages.getString("AttachIpAction.0"));
        this.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"jp.co.intellilink.aws.ui", (String)"icons/monitor_add.png"));
        this.setEnabled(false);
    }

    public void run() {
        super.run();
        PreferenceStore store = new PreferenceStore();
        Job job = new Job(Messages.getString("AttachIpAction.2"), (IPreferenceStore)store){
            private final /* synthetic */ IPreferenceStore val$store;
            {
                this.val$store = iPreferenceStore;
                super($anonymous0);
            }

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask(Messages.getString("AttachIpAction.3"), 10);
                    monitor.setTaskName(Messages.getString("AttachIpAction.4"));
                    EC2ServiceProvider provider = Activator.getDefault().getProvider();
                    monitor.worked(2);
                    ElasticComputingCloudInterface ec2 = provider.getEC2();
                    monitor.setTaskName(Messages.getString("AttachIpAction.5"));
                    final ArrayList<String> instances = new ArrayList<String>();
                    EC2DescribeInstanceRequest request = new EC2DescribeInstanceRequest();
                    List instance = ec2.describeInstance(request);
                    for (EC2Instance i : instance) {
                        instances.add(i.getId());
                    }
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            AttachIpWizard wizard = new AttachIpWizard(val$store);
                            wizard.setInstances(instances);
                            WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
                            dialog.open();
                        }
                    });
                    if (!this.val$store.getString("instanceId").equals("")) {
                        monitor.setTaskName(Messages.getString("AttachIpAction.8"));
                        EC2AssociateRequest ass = new EC2AssociateRequest();
                        ass.setInstanceId(this.val$store.getString("instanceId"));
                        ass.setPublicIp(AttachIpAction.this.model.getIp());
                        ec2.associateAddress(ass);
                        monitor.setTaskName(Messages.getString("AttachIpAction.10"));
                        final List address = ec2.describeAddress(new EC2DescribeAddressRequest());
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                AttachIpAction.this.getHandler().onDescribeAddressExecuted(address);
                            }
                        });
                    }
                    monitor.done();
                    return Status.OK_STATUS;
                }
                catch (CoreException e) {
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.getString("AttachIpAction.11"), (String)e.getMessage());
                    return Status.CANCEL_STATUS;
                }
            }
        };
        job.schedule();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (selection.getFirstElement() instanceof ElasticIPModel) {
            this.model = (ElasticIPModel)selection.getFirstElement();
            if (this.model.getInstanceId() == null || "".equals(this.model.getInstanceId())) {
                this.setEnabled(true);
            }
        } else {
            this.setEnabled(false);
        }
    }
}

