/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.aws.ui.job;

import jp.co.intellilink.aws.api.ElasticComputingCloudInterface;
import jp.co.intellilink.aws.api.transport.EC2AttachVolumeRequest;
import jp.co.intellilink.aws.core.CoreException;
import jp.co.intellilink.aws.core.EC2ServiceProvider;
import jp.co.intellilink.aws.ui.Activator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;

public class AttachVolumeJob
extends Job {
    private final IPreferenceStore store;

    public AttachVolumeJob(String name, IPreferenceStore store) {
        super(name);
        this.store = store;
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask("AddIpPermission", 0);
        monitor.setTaskName("Resolve EC2 Client...");
        EC2ServiceProvider provider = Activator.getDefault().getProvider();
        monitor.worked(10);
        monitor.setTaskName("Add Ip Permission...");
        try {
            ElasticComputingCloudInterface client = provider.getEC2();
            EC2AttachVolumeRequest request = new EC2AttachVolumeRequest();
            request.setVolumeId(this.store.getString("volumeId"));
            request.setInstanceId(this.store.getString("instanceId"));
            request.setDevice(this.store.getString("device"));
            monitor.worked(70);
            client.attachVolume(request);
            monitor.worked(90);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return Status.CANCEL_STATUS;
        }
        monitor.done();
        return Status.OK_STATUS;
    }
}

