/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.aws.ui.job;

import java.util.List;
import jp.co.intellilink.aws.api.ElasticComputingCloudInterface;
import jp.co.intellilink.aws.api.transport.EC2CreateVolumeRequest;
import jp.co.intellilink.aws.api.transport.EC2DescribeVolumesRequest;
import jp.co.intellilink.aws.core.CoreException;
import jp.co.intellilink.aws.core.EC2ServiceProvider;
import jp.co.intellilink.aws.ui.Activator;
import jp.co.intellilink.aws.ui.view.ActionCallbackHandler;
import jp.co.intellilink.aws.ui.view.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class CreateVolumeJob
extends Job {
    private final IPreferenceStore store;
    private final ActionCallbackHandler handler;

    public CreateVolumeJob(IPreferenceStore store, ActionCallbackHandler handler) {
        super("CreateVolumeJob");
        this.store = store;
        this.handler = handler;
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask("CreateSecurityGroup", 0);
        monitor.setTaskName("Resolve EC2 Client...");
        EC2ServiceProvider provider = Activator.getDefault().getProvider();
        monitor.worked(10);
        monitor.setTaskName("Request Generating...");
        EC2CreateVolumeRequest request = new EC2CreateVolumeRequest();
        request.setAvailabilityZone(this.store.getString("zone"));
        if (!this.store.getString("size").isEmpty()) {
            request.setSize(this.store.getString("size"));
        }
        if (!this.store.getString("snapshot").isEmpty()) {
            request.setSnapshotId(this.store.getString("snapshot"));
        }
        monitor.worked(40);
        try {
            ElasticComputingCloudInterface client = provider.getEC2();
            monitor.setTaskName("API Calling...");
            client.createVolume(request);
            monitor.worked(70);
            final List volumes = client.describeVolumes(new EC2DescribeVolumesRequest());
            monitor.worked(90);
            if (this.handler != null && volumes != null) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        CreateVolumeJob.this.handler.onDescribeVolumes(volumes);
                    }
                });
            }
            monitor.done();
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.getString("Failed to connnect."), (String)e.getMessage());
            return Status.CANCEL_STATUS;
        }
    }
}

