/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.aws.ui.job;

import java.util.List;
import jp.co.intellilink.aws.api.ElasticComputingCloudInterface;
import jp.co.intellilink.aws.api.transport.EC2DescribeSecurityGroupRequest;
import jp.co.intellilink.aws.api.transport.EC2RevokeSecurityGroupIngressRequest;
import jp.co.intellilink.aws.core.CoreException;
import jp.co.intellilink.aws.core.EC2ServiceProvider;
import jp.co.intellilink.aws.ui.Activator;
import jp.co.intellilink.aws.ui.model.GroupRule;
import jp.co.intellilink.aws.ui.model.IPRangeRule;
import jp.co.intellilink.aws.ui.model.NetworkRule;
import jp.co.intellilink.aws.ui.view.ActionCallbackHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;

public class DeleteIpPermissionJob
extends Job {
    private ActionCallbackHandler handler;
    private List<NetworkRule> models;

    public DeleteIpPermissionJob(String name, ActionCallbackHandler handler, List<NetworkRule> models) {
        super(name);
        this.handler = handler;
        this.models = models;
    }

    protected IStatus run(IProgressMonitor monitor) {
        List securityGroups;
        monitor.beginTask("Delete IP Permissions.", 10);
        monitor.setTaskName("Delete IP Permissions");
        monitor.setTaskName("Resolve EC2 Client...");
        EC2ServiceProvider provider = Activator.getDefault().getProvider();
        ElasticComputingCloudInterface client = null;
        try {
            client = provider.getEC2();
            for (NetworkRule model : this.models) {
                IPRangeRule rule;
                EC2RevokeSecurityGroupIngressRequest request = new EC2RevokeSecurityGroupIngressRequest();
                request.setGroupName(model.getGroupName());
                request.setFromPort(Integer.valueOf(model.getFromPort()));
                request.setToPort(Integer.valueOf(model.getToPort()));
                request.setIpProtocol(model.getProtcol());
                if (model instanceof IPRangeRule) {
                    rule = (IPRangeRule)model;
                    request.setCidrIp(rule.getCidrIp());
                } else if (model instanceof GroupRule) {
                    rule = (GroupRule)model;
                    request.setSourceSecurityGroup(rule.getSourceSecurityGroupName());
                    request.setSourceSecurityGroupOwnerId(rule.getSourceSecurityGroupOwnerId());
                }
                client.revokeSecurityGroupIngress(request);
            }
            securityGroups = client.describeSecurityGroups(new EC2DescribeSecurityGroupRequest());
        }
        catch (CoreException e) {
            e.printStackTrace();
            return Status.CANCEL_STATUS;
        }
        if (this.handler != null) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    DeleteIpPermissionJob.this.handler.onDescribeSecurityGroupsExecuted(securityGroups);
                }
            });
        }
        return Status.OK_STATUS;
    }
}

