/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.aws.ui.job;

import java.util.ArrayList;
import java.util.List;
import jp.co.intellilink.aws.api.ElasticComputingCloudInterface;
import jp.co.intellilink.aws.api.transport.EC2DeleteVolumeRequest;
import jp.co.intellilink.aws.api.transport.EC2DescribeVolumesRequest;
import jp.co.intellilink.aws.core.CoreException;
import jp.co.intellilink.aws.core.EC2ServiceProvider;
import jp.co.intellilink.aws.ui.Activator;
import jp.co.intellilink.aws.ui.model.VolumeModel;
import jp.co.intellilink.aws.ui.view.ActionCallbackHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;

public class DeleteVolumeJob
extends Job {
    private ActionCallbackHandler handler;
    private List<VolumeModel> models;

    public DeleteVolumeJob(String name, ActionCallbackHandler handler, List<VolumeModel> models) {
        super(name);
        this.handler = handler;
        this.models = models;
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask("Delete Volumes.", 10);
        monitor.setTaskName("Delete Volumes");
        monitor.setTaskName("Resolve EC2 Client...");
        EC2ServiceProvider provider = Activator.getDefault().getProvider();
        ElasticComputingCloudInterface client = null;
        monitor.worked(30);
        monitor.setTaskName("Request Generating...");
        final ArrayList volumes = new ArrayList();
        try {
            client = provider.getEC2();
            for (VolumeModel volume : this.models) {
                EC2DeleteVolumeRequest request = new EC2DeleteVolumeRequest(volume.getVolumeId());
                client.deleteVolume(request);
            }
            monitor.worked(90);
            volumes.addAll(client.describeVolumes(new EC2DescribeVolumesRequest()));
        }
        catch (CoreException e) {
            e.printStackTrace();
            return Status.CANCEL_STATUS;
        }
        if (this.handler != null) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    DeleteVolumeJob.this.handler.onDescribeVolumes(volumes);
                }
            });
        }
        monitor.done();
        return Status.OK_STATUS;
    }
}

