/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.aws.ui.job;

import java.util.List;
import jp.co.intellilink.aws.api.ElasticComputingCloudInterface;
import jp.co.intellilink.aws.api.transport.EC2DescribeVolumesRequest;
import jp.co.intellilink.aws.core.CoreException;
import jp.co.intellilink.aws.core.EC2ServiceProvider;
import jp.co.intellilink.aws.ui.Activator;
import jp.co.intellilink.aws.ui.view.ActionCallbackHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;

public class DescribeVolumesJob
extends Job {
    private ActionCallbackHandler handler;
    private List<String> volumeIds;

    public DescribeVolumesJob(String name, ActionCallbackHandler handler, List<String> volumeIds) {
        super(name);
        this.handler = handler;
        this.volumeIds = volumeIds;
    }

    protected IStatus run(IProgressMonitor monitor) {
        List volumes;
        monitor.beginTask("DescribeVolumes", 0);
        monitor.setTaskName("Resolve EC2 Client...");
        EC2ServiceProvider provider = Activator.getDefault().getProvider();
        monitor.worked(10);
        monitor.setTaskName("Describe Volumes...");
        try {
            ElasticComputingCloudInterface client = provider.getEC2();
            EC2DescribeVolumesRequest request = new EC2DescribeVolumesRequest(this.volumeIds);
            volumes = client.describeVolumes(request);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return Status.CANCEL_STATUS;
        }
        if (this.handler != null && volumes != null) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    DescribeVolumesJob.this.handler.onDescribeVolumes(volumes);
                }
            });
        }
        return Status.OK_STATUS;
    }
}

