/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.aws.ui.wizard;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class AddIpPermissionWizardPage
extends WizardPage {
    private static final String[][] PROTOCOLS = new String[][]{{"TCP", "tcp"}, {"UDP", "udp"}, {"ICMP", "icmp"}};
    private final IPreferenceStore store;
    private List<FieldEditor> editors = new ArrayList<FieldEditor>();
    private ComboFieldEditor protocolComboEditor;
    private StringFieldEditor portEditor;
    private StringFieldEditor sourceCidrIpEditor;

    protected AddIpPermissionWizardPage(IPreferenceStore store) {
        super("IP Permission Setting");
        this.setTitle("Add IP Permission");
        this.setDescription("Add New IP Permission.");
        this.store = store;
    }

    public void createControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        Label groupLabel = new Label(composite, 0);
        groupLabel.setText("Security Group");
        Label group = new Label(composite, 0);
        group.setText(this.store.getString("securityGroup"));
        this.protocolComboEditor = new ComboFieldEditor("protocol", "Protocol", PROTOCOLS, composite);
        this.protocolComboEditor.setPreferenceStore(this.store);
        this.editors.add((FieldEditor)this.protocolComboEditor);
        this.portEditor = new StringFieldEditor("portRange", "Port or Port Range (ex: port 8080 or range 0-8080)", composite);
        this.portEditor.setPreferenceStore(this.store);
        this.editors.add((FieldEditor)this.portEditor);
        this.sourceCidrIpEditor = new StringFieldEditor("cidrIp", "CIDR IP address range (ex: 0.0.0.0/0", composite);
        this.sourceCidrIpEditor.setPreferenceStore(this.store);
        this.editors.add((FieldEditor)this.sourceCidrIpEditor);
        this.setControl((Control)parent);
    }

    public void onFinish() {
        for (FieldEditor editor : this.editors) {
            editor.store();
        }
    }
}

