/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.aws.api;

import org.eclipse.core.internal.net.ProxyManager;
import org.eclipse.core.net.proxy.IProxyChangeEvent;
import org.eclipse.core.net.proxy.IProxyChangeListener;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;

public class ProxyConfigurator
implements IProxyChangeListener {
    public void init() {
        IProxyService manager = ProxyManager.getProxyManager();
        this.setSystemProperties(manager);
        manager.addProxyChangeListener((IProxyChangeListener)this);
    }

    private void setSystemProperties(IProxyService manager) {
        if (manager.isProxiesEnabled()) {
            IProxyData[] data = manager.getProxyData();
            String[] nonProxiedHosts = manager.getNonProxiedHosts();
            StringBuilder builder = new StringBuilder();
            String[] stringArray = nonProxiedHosts;
            int n = nonProxiedHosts.length;
            int n2 = 0;
            while (n2 < n) {
                String host = stringArray[n2];
                builder.append(host);
                builder.append("|");
                ++n2;
            }
            System.setProperty("http.nonProxyHosts", builder.toString());
            System.setProperty("https.nonProxyHosts", builder.toString());
            stringArray = data;
            n = data.length;
            n2 = 0;
            while (n2 < n) {
                String proxyData = stringArray[n2];
                if ("HTTP".equals(proxyData.getType())) {
                    System.setProperty("http.proxyHost", proxyData.getHost());
                    System.setProperty("http.proxyPort", String.valueOf(proxyData.getPort()));
                    if (proxyData.isRequiresAuthentication()) {
                        System.setProperty("http.proxyUser", proxyData.getUserId());
                        System.setProperty("http.proxyPassword", proxyData.getPassword());
                    } else {
                        System.clearProperty("http.proxyUser");
                        System.clearProperty("http.proxyPassword");
                    }
                } else if ("HTTPS".equals(proxyData.getType())) {
                    System.setProperty("https.proxyHost", proxyData.getHost());
                    System.setProperty("https.proxyPort", String.valueOf(proxyData.getPort()));
                    if (proxyData.isRequiresAuthentication()) {
                        System.setProperty("https.proxyUser", proxyData.getUserId());
                        System.setProperty("https.proxyPassword", proxyData.getPassword());
                    } else {
                        System.clearProperty("https.proxyUser");
                        System.clearProperty("https.proxyPassword");
                    }
                }
                ++n2;
            }
        }
    }

    public void proxyInfoChanged(IProxyChangeEvent event) {
        IProxyService manager = ProxyManager.getProxyManager();
        this.setSystemProperties(manager);
    }

    public void stop() {
        IProxyService manager = ProxyManager.getProxyManager();
        manager.removeProxyChangeListener((IProxyChangeListener)this);
    }
}

