/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.aws.core;

import jp.co.intellilink.aws.api.AWSServiceProvider;
import jp.co.intellilink.aws.api.ElasticComputingCloudInterface;
import jp.co.intellilink.aws.core.CoreException;
import org.eclipse.jface.preference.IPreferenceStore;

public class EC2ServiceProvider {
    private ElasticComputingCloudInterface ec2;
    private String url;
    private String client;
    private String accessKey;
    private String secretKey;

    public EC2ServiceProvider(IPreferenceStore store) {
        this.url = store.getString("service_url");
        this.client = store.getString("client");
        this.accessKey = store.getString("access_key");
        this.secretKey = store.getString("secret_key");
    }

    public ElasticComputingCloudInterface getEC2() throws CoreException {
        if (this.ec2 == null && this.canGetEC2()) {
            this.ec2 = AWSServiceProvider.getInstance().getEC2Interface(this.client);
            this.ec2.configureUrl(this.url);
            this.ec2.configure(this.accessKey, this.secretKey);
        }
        return this.ec2;
    }

    public boolean canGetEC2() {
        return !this.isNullOrEmpty(this.accessKey) && !this.isNullOrEmpty(this.secretKey) && !this.isNullOrEmpty(this.url);
    }

    private boolean isNullOrEmpty(String in) {
        return in == null || in.isEmpty();
    }
}

